% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_aliases.R, R/stack_prod.R
\name{prodStackAliases}
\alias{prodStackAliases}
\alias{setProdStackAlias}
\alias{prodStack}
\title{Visualize the production stack of an area}
\usage{
prodStackAliases()

setProdStackAlias(name, variables, colors, lines = NULL, lineColors = NULL,
  lineWidth = 3, description = NULL)

prodStack(x, stack = "eco2mix", areas = NULL, mcYear = "average",
  dateRange = NULL, main = .getLabelLanguage("Production stack", language),
  unit = c("MWh", "GWh", "TWh"), compare = NULL, compareOpts = list(),
  interactive = getInteractivity(), legend = TRUE,
  legendId = sample(1e+09, 1), groupId = legendId, legendItemsPerRow = 5,
  width = NULL, height = NULL, xyCompare = c("union", "intersect"),
  h5requestFiltering = list(), stepPlot = FALSE, drawPoints = FALSE,
  timeSteph5 = "hourly", mcYearh5 = NULL, tablesh5 = c("areas", "links"),
  language = "en", hidden = NULL, ...)
}
\arguments{
\item{name}{name of the stack to create or update}

\item{variables}{A named list of expressions created with \code{\link[base]{alist}}. The
name of each element is the name of the variable to draw in the stacked
graph. The element itself is an expression explaining how to compute the
variable (see examples).}

\item{colors}{Vector of colors with same length as parameter \code{variables}. If 
\code{variables} is an alias, then this argument should be \code{NULL} in 
order to use default colors.}

\item{lines}{A named list of expressions created with \code{\link[base]{alist}}
indicating how to compute the curves to display on top of the stacked graph.
It should be \code{NULL} if there is no curve to trace or if parameter
\code{variables} is an alias.}

\item{lineColors}{Vector of colors with same length as parameter \code{lines}. This argument
should be \code{NULL} if there is no curve to trace or if parameter
\code{variables} is an alias.}

\item{lineWidth}{Optionnal. Defaut to 3. Vector of width with same length as parameter \code{lines} (or only one value).}

\item{description}{Description of the stack. It is displayed by function 
\code{prodStackAliases}.}

\item{x}{An object of class \code{antaresData} created with function 
\code{\link[antaresRead]{readAntares}} containing data for areas and or
districts. it can be a list of \code{antaresData} objects. 
In this case, one chart is created for each object. 
Can also contains opts who refer to a h5 file or list of opts.}

\item{stack}{Name of the stack to use. One can visualize available stacks with 
\code{prodStackAliases}}

\item{areas}{Vector of area or district names. The data of these areas or districts is
aggregated by the function to construct the production stack.}

\item{mcYear}{If \code{x}, contains multiple Monte-Carlo scenarios, this parameter 
determine which scenario is displayed. Must be an integer representing the
index of the scenario or the word "average". In this case data are 
averaged.}

\item{dateRange}{A vector of two dates. Only data points between these two dates are 
displayed. If NULL, then all data is displayed.}

\item{main}{Title of the graph.}

\item{unit}{Unit used in the graph. Possible values are "MWh", "GWh" or "TWh".}

\item{compare}{An optional character vector containing names of parameters. When it is set,
two charts are outputed with their own input controls. Alternatively, it can
be a named list with names corresponding to parameter names and values being
list with the initial values of the given parameter for each chart. See details
 if you are drawing a map.}

\item{compareOpts}{List of options that indicates the number of charts to create and their 
position. Check out the documentation of 
\code{\link[manipulateWidget]{compareOptions}} to see available options.}

\item{interactive}{LogicalValue. If \code{TRUE}, then a shiny gadget is launched that lets
the user interactively choose the areas or districts to display.}

\item{legend}{Logical value indicating if a legend should be drawn. This argument is 
usefull when one wants to create a shared legend with
\code{\link{prodStackLegend}}}

\item{legendId}{Id of the legend linked to the graph. This argument is 
usefull when one wants to create a shared legend with 
\code{\link{prodStackLegend}}}

\item{groupId}{Parameter that can be used to synchronize the horizontal 
zoom of multiple charts. All charts that need to be synchronized must
have the same group.}

\item{legendItemsPerRow}{Number of elements to put in each row of the legend.}

\item{width}{Width of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{height}{Height of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{xyCompare}{Use when you compare studies, can be "union" or "intersect". If union, all
of mcYears in one of studies will be selectable. If intersect, only mcYears in all
studies will be selectable.}

\item{h5requestFiltering}{Contains arguments used by default for h5 request,
typically h5requestFiltering = list(select = "NUCLEAR")}

\item{stepPlot}{\code{boolean}, step style for curves.}

\item{drawPoints}{\code{boolean}, add points on graph}

\item{timeSteph5}{\code{character} timeStep to read in h5 file. Only for Non interactive mode.}

\item{mcYearh5}{\code{numeric} mcYear to read for h5. Only for Non interactive mode.}

\item{tablesh5}{\code{character} tables for h5 ("areas" "links", "clusters" or "disticts"). Only for Non interactive mode.}

\item{language}{\code{character} language use for label. Defaut to 'en'. Can be 'fr'.}

\item{hidden}{\code{logical} Names of input to hide. Defaut to NULL}

\item{...}{Other arguments for \code{\link{manipulateWidget}}}
}
\value{
\code{prodStack} returns an interactive html graphic. If argument
\code{interactive} is \code{TRUE}, then a shiny gadget is started and the
function returns an interactive html graphic when the user clicks on button
"Done".

\code{prodStackAliases} displays the list of available aliases.

\code{setProdStackAlias} creates or updates a stack alias.
}
\description{
\code{prodStack} draws the production stack for a set of areas or districts.
User can see available stacks with \code{prodStackAliases} and create new ones
with \code{setProdStackAlias}.
}
\details{
compare argument can take following values :
\itemize{
   \item "mcYear"
   \item "main"
   \item "unit"
   \item "areas"
   \item "legend"
   \item "stack"
   \item "stepPlot"
   \item "drawPoints"
   }
}
\examples{
\dontrun{
mydata <- readAntares(areas = "all", timeStep = "daily")

# Start a shiny gadget that permits to choose areas to display.
prodStack(x = mydata, unit = "GWh")

# Use in a non-interactive way
prodStack(x = mydata, unit = "GWh", areas = "fr", interactive = FALSE)

# Define a custom stack
setProdStackAlias(
  name = "Wind and solar",
  variables = alist(wind = WIND, solar = SOLAR),
  colors = c("green", "orange")
)

prodStack(x = mydata, unit = "GWh", stack = "Wind and solar")
                
# In a custom stack it is possible to use computed values
setProdStackAlias(
  name = "Renewable",
  variables = alist(
    renewable = WIND + SOLAR + `H. ROR` + `H. STOR` + `MISC. NDG`, 
    thermal = NUCLEAR + LIGNITE + COAL + GAS + OIL + `MIX. FUEL` + `MISC. DTG`
  ),
  colors = c("green", gray(0.3)),
  lines = alist(goalRenewable = LOAD * 0.23),
  lineColors = "#42EB09"
)

prodStack(x = mydata, unit = "GWh", stack = "renewable")

# Use compare
prodStack(x = mydata, compare = "areas")
prodStack(x = mydata, unit = "GWh", compare = "mcYear")
prodStack(x = mydata, unit = "GWh", compare = "main")
prodStack(x = mydata, unit = "GWh", compare = "unit")
prodStack(x = mydata, unit = "GWh", compare = "areas")
prodStack(x = mydata, unit = "GWh", compare = "legend")
prodStack(x = mydata, unit = "GWh", compare = "stack")
prodStack(x = mydata, unit = "GWh", compare = c("mcYear", "areas"))


# Compare studies
prodStack(list(mydata, mydata))


# Use h5 opts
# Set path of simulaiton
setSimulationPath(path = path1)

# Convert your study in h5 format
writeAntaresH5(path = mynewpath)

# Redefine sim path with h5 file
opts <- setSimulationPath(path = mynewpath)
prodStack(x = opts)

# Compare elements in a single study
prodStack(x = opts, .compare = "mcYear")

# Compare 2 studies
prodStack(x = list(opts, opts2))


                
}

}
\seealso{
\code{\link{prodStackLegend}}
}
