% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BertrandRUMClasses.R
\docType{class}
\name{BertrandRUM-Classes}
\alias{BertrandRUM-Classes}
\alias{Logit-class}
\alias{LogitCap-class}
\alias{LogitCapALM-class}
\alias{LogitNests-class}
\alias{LogitNestsALM-class}
\alias{LogitALM-class}
\alias{CES-class}
\alias{CESALM-class}
\alias{CESNests-class}
\title{\dQuote{Bertrand RUM} Classes}
\description{
Each class contains all the information needed to calibrate a specific type of demand system and
perform a merger simulation analysis under the assumption that firms are playing a differentiated products Bertrand pricing game.

The \dQuote{Logit} class has the information for a Logit demand system.

The \dQuote{LogitCap} class has the information for a Logit demand system and assumes that
firms are playing a differentiated products Bertrand pricing game with capacity constraints.
\dQuote{LogitCapALM} extends \dQuote{LogitCap} to allow for an unobserved outside share.

The \dQuote{LogitNests} class has the information for a nested Logit

The \dQuote{LogitNestsALM} class has the information for a nested Logit
demand system under the assumption that the share of the outside product is not known.
Once the model parameters have been calibrated, methods exist that perform a merger simulation analysis under the assumption that
firms are playing a differentiated products Bertrand pricing game.

The \dQuote{LogitALM} class has the information for a Logit demand system
assuming that firms are playing a differentiated products Bertrand pricing game with unknown market elasticity.

The \dQuote{CES} class has the information for a CES demand system

The \dQuote{CESALM} class has the information for a CES demand system and
assumes that firms are playing a differentiated products Bertrand pricing game with unknown market elasticity.

The \dQuote{CESNests} class has the information for a nested CES demand system.

Let k denote the number of products produced by all firms below.
}
\section{Slots}{

\describe{
\item{\code{prices}}{A length k vector of product prices.}

\item{\code{margins}}{A length k vector of product margins, some of which may equal NA.}

\item{\code{normIndex}}{An integer specifying the product index against which the mean values of all other products are normalized.}

\item{\code{shareInside}}{The share of customers that purchase any of the products included in the `prices' vector.}

\item{\code{priceOutside}}{The price of the outside good. Default is 0.}

\item{\code{slopes}}{A list containing the coefficient on price (\sQuote{alpha}) and the vector of mean valuations (\sQuote{meanval}).}

\item{\code{mktElast}}{A length 1 vector of market elasticities.}

\item{\code{priceStart}}{A length-k vector of starting prices for the non-linear solver.}

\item{\code{insideSize}}{A positive number equal to total pre-merger quantities (revenues for CES) for all products included in the simulation.}

\item{\code{mktSize}}{A positive number equal to total quantities (revenues for CES) pre-merger for all products in the simulations
as well as the outside good.}

\item{\code{capacitiesPre}}{A length k vector whose elements equal pre-merger product capacities. (LogitCap and LogitCapALM only)}

\item{\code{capacitiesPost}}{A length k vector whose elements equal post-merger product capacities. (LogitCap and LogitCapALM only)}

\item{\code{nests}}{A length k vector identifying the nest that each product belongs to. (LogitNests and CESNests Only)}

\item{\code{parmsStart}}{A length k vector who elements equal an initial guess of the nesting parameter values. (LogitNests and CESNests Only)}

\item{\code{constraint}}{A length 1 logical vector that equals TRUE if all nesting parameters are constrained to equal the same value
and FALSE otherwise. Default is TRUE. (LogitNests and CESNests Only)}

\item{\code{parmsStart}}{A length 2 vector whose first element equals an initial guess of the price coefficient and whose second
element equals an initial guess of the outside share. The price
coefficient's initial value must be negative and the outside share's initial value must be between 0 and 1. (LogitALM and CESALM only)}

\item{\code{slopes}}{A list containing the coefficient on the numeraire (`alpha'),  the coefficient on price (\sQuote{gamma}), and the vector of mean
valuations (\sQuote{meanval}) (CES only)}

\item{\code{priceOutside}}{The price of the outside good. Default is 1. (CES only)}
}}

\section{Objects from the Class}{

For Logit, objects can be created by using the constructor function \code{\link{logit}}.

For LogitALM, objects can be created by using the constructor function \code{\link{logit.alm}}.

For LogitCap and LogitCapALM, objects can be created by using the constructor function \code{\link{logit.cap}} and \code{\link{logit.cap.alm}}.

For LogitNests, objects can be created by using the constructor function \code{\link{logit.nests}}.

For LogitNestsALM, objects can be created by using the constructor function \code{\link{logit.nests.alm}}.

For CES, objects can be created by using the constructor function \code{\link{ces}}.

For CESALM, objects can be created by using the constructor function \code{\link{ces.alm}}.

For CESNests, objects can be created by using the constructor function \code{\link{ces.nests}}.
}

\section{Extends}{

Logit: Class \code{\linkS4class{Bertrand}}, directly.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 2.

LogitCap: Class \code{\linkS4class{Logit}}, directly.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 2.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 3.

#'LogitCapALM: Class \code{\linkS4class{LogitCap}}, directly.
Class \code{\linkS4class{Logit}}, by class \code{\linkS4class{LogitCap}}, distance 2.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 3.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 4.

LogitNests: Class \code{\linkS4class{Logit}}, directly.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 2.

LogitNestsALM: Class \code{\linkS4class{LogitNests}}, directly.
Class \code{\linkS4class{Logit}}, by class \code{\linkS4class{LogitNests}}, distance 2.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 3.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 4.

LogitALM: Class \code{\linkS4class{Logit}}, directly.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 2.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 3.

CES: Class \code{\linkS4class{Logit}}, directly.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 2.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 3.

CESALM: Class \code{\linkS4class{CES}}, directly.
Class \code{\linkS4class{Logit}}, by class \code{\linkS4class{CES}}, distance 2.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 3.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 4.

CESNests: Class \code{\linkS4class{CES}}, directly.
Class \code{\linkS4class{Logit}}, by class \code{\linkS4class{CES}}, distance 2.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 3.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 4.
}

\examples{
showClass("Logit")           # get a detailed description of the class
showClass("LogitCap")           # get a detailed description of the class
showClass("LogitNests")           # get a detailed description of the class
showClass("LogitNestsALM")           # get a detailed description of the class
showClass("LogitALM")           # get a detailed description of the class
showClass("CES")           # get a detailed description of the class
showClass("CESALM")           # get a detailed description of the class
showClass("CESNests")           # get a detailed description of the class
}
\author{
Charles Taragin \email{ctaragin@ftc.gov}
}
