% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMCRBertrandFunctions.R
\name{CMCRBertrand-Functions}
\alias{CMCRBertrand-Functions}
\alias{cmcr.bertrand}
\alias{upp.bertrand}
\alias{upp}
\alias{cmcr}
\title{Compensating Marginal Cost Reductions and Upwards Pricing Pressure (Bertrand)}
\usage{
cmcr.bertrand(prices, margins, diversions, ownerPre,
  ownerPost = matrix(1, ncol = length(prices), nrow = length(prices)),
  labels = paste("Prod", 1:length(prices), sep = ""))

upp.bertrand(prices, margins, diversions, ownerPre, ownerPost = matrix(1,
  ncol = length(prices), nrow = length(prices)), mcDelta = rep(0,
  length(prices)), labels = paste("Prod", 1:length(prices), sep = ""))
}
\arguments{
\item{prices}{A length-k vector of product prices.}

\item{margins}{A length-k vector of product margins.}

\item{diversions}{A k x k matrix of diversion ratios
with diagonal elements equal to -1.}

\item{ownerPre}{EITHER a vector of length k whose values
indicate which of the merging parties produced a product pre-merger OR
a k x k matrix of pre-merger ownership shares.}

\item{ownerPost}{A k x k matrix of post-merger
ownership shares. Default is a k x k matrix of 1s.}

\item{labels}{A length-k vector of product labels.}

\item{mcDelta}{A vector of length k where each element equals the
proportional change in a product's marginal costs due to
the merger. Default is 0, which assumes that the merger does not
affect any products' marginal cost.}
}
\value{
\code{cmcr.bertrand} returns a length-k vector whose values
equal the percentage change in each products'
marginal costs that the merged firms must achieve in order to offset a
price increase.

\code{upp.bertrand} returns a length-k vector whose values equal
the generalized pricing pressure (GePP) for each of the merging's parties' products,
net any efficiency claims. GePP is a generalization of Upwards Pricing Pressure (UPP)
that accomodates multi-product firms.
}
\description{
Calculate the marginal cost reductions necessary to restore
premerger prices (CMCR), or the net Upwards Pricing Pressure (UPP) in a
merger involving firms playing a differentiated products Bertrand pricing game.

Let k denote the number of products produced by the merging parties below.
}
\details{
All \sQuote{prices} elements must be positive, all \sQuote{margins}
elements must be between 0 and 1, and all \sQuote{diversions} elements must be
between 0 and 1 in absolute value. In
addition, off-diagonal elements (i,j) of \sQuote{diversions}
must equal an estimate of the diversion ratio from product i to product j
(i.e. the estimated fraction of i's sales that go to j due to a small
increase in i's price). Also, \sQuote{diversions}
elements are positive if i and j are substitutes and negative if i and j are
complements.

\sQuote{ownerPre} will typically be a vector whose values equal 1 if a product is produced
by firm 1 and 0 otherwise, though other values including firm name are
acceptable.  Optionally, \sQuote{ownerPre} may be set equal
to a matrix of the merging firms pre-merger ownership
shares. These ownership shares must be between 0 and 1.

\sQuote{ownerPost}  is an optional argument that should only be specified if
one party to the acquisition is assuming partial control of the
other party's assets.   \sQuote{ownerPost} elements must be between 0 and
1.
}
\examples{
## Let k_1 = 1 and and k_2 = 2 ##

p1 = 50;      margin1 = .3
p2 = c(45,70); margin2 = c(.4,.6)
isOne=c(1,0,0)
diversions = matrix(c(-1,.5,.01,.6,-1,.1,.02,.2,-1),ncol=3)

cmcr.bertrand(c(p1,p2), c(margin1,margin2), diversions, isOne)
upp.bertrand(c(p1,p2), c(margin1,margin2), diversions, isOne)


## Calculate the necessary percentage cost reductions for various margins and
## diversion ratios in a two-product merger where both products have
## equal prices and diversions (see Werden 1996, pg. 412, Table 1)


margins = seq(.4,.7,.1)
diversions = seq(.05,.25,.05)
prices = rep(1,2) #assuming prices are equal, we can set product prices to 1
isOne = c(1,0)
result = matrix(ncol=length(margins),nrow=length(diversions),dimnames=list(diversions,margins))

for(m in 1:length(margins)){
  for(d in 1:length(diversions)){

    dMatrix = -diag(2)
    dMatrix[2,1] <- dMatrix[1,2] <- diversions[d]

    firmMargins = rep(margins[m],2)

    result[d,m] = cmcr.bertrand(prices, firmMargins, dMatrix, isOne)[1]

  }}

print(round(result,1))

}
\references{
Farrell, Joseph and Shapiro, Carl (2010).
\dQuote{Antitrust Evaluation of Horizontal Mergers: An Economic Alternative to
Market Definition.}
\emph{The B.E. Journal of Theoretical Economics}, \bold{10}(1), pp. 1-39.

Jaffe, Sonia and Weyl Eric (2012).
\dQuote{The First-Order Approach to Merger Analysis.}
\emph{SSRN eLibrary}

Werden, Gregory (1996).
\dQuote{A Robust Test for Consumer Welfare Enhancing Mergers Among Sellers
of Differentiated Products.}
\emph{The Journal of Industrial Economics}, \bold{44}(4), pp. 409-413.
}
\seealso{
\code{\link{cmcr.cournot}} for a homogeneous products Cournot
version of CMCR, and \code{\link{cmcr-methods}} for calculating
CMCR and UPP after calibrating demand system parameters and simulating a merger.
}
\author{
Charles Taragin \email{ctaragin@ftc.gov}
}
