% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OwnershipMethods.R
\docType{methods}
\name{Ownership-methods}
\alias{Ownership-methods}
\alias{ownerToMatrix}
\alias{ownerToVec}
\alias{ownerToMatrix,Antitrust-method}
\alias{ownerToMatrix,VertBargBertLogit-method}
\alias{ownerToVec,Antitrust-method}
\title{Methods for Manipulating Ownership Matrices}
\usage{
\S4method{ownerToMatrix}{Antitrust}(object, preMerger = TRUE)

\S4method{ownerToMatrix}{VertBargBertLogit}(object, preMerger = TRUE)

\S4method{ownerToVec}{Antitrust}(object, preMerger = TRUE)
}
\arguments{
\item{object}{An instance of the Antitrust class.}

\item{preMerger}{The \sQuote{preMerger} takes
on a value of TRUE or FALSE, where TRUE invokes the method using the
pre-merger values, while FALSE invokes the method using the post-merger ownership structure.}
}
\description{
\code{ownerToMatrix} converts an ownership vector (or factor) to a k x k matrix of
1s and 0s.

\code{ownerToVec} converts a k x k  ownership matrix to a length-k
vector whose values identify an owner.
}
\examples{
showMethods(classes="Antitrust") # show all methods defined for the class

}
\author{
Charles Taragin \email{ctaragin@ftc.gov}
}
\keyword{methods}
