% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_population.R
\name{read_population}
\alias{read_population}
\title{Download population and socioeconomic data}
\usage{
read_population(
  city = "bel",
  year = 2010,
  geometry = FALSE,
  showProgress = TRUE
)
}
\arguments{
\item{city}{Character. A city name or three-letter abbreviation. If
\code{city="all"}, results for all cities are loaded.}

\item{year}{Numeric. A year number in YYYY format. Default set to 2019, the
only year currently available.}

\item{geometry}{Logical. If \code{FALSE} (the default), returns a regular data.table
of aop data. If \code{TRUE}, returns a an \verb{sf data.frame} with simple
feature geometry of spatial hexagonal grid H3. See details in
\link{read_grid}.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar}
}
\value{
A \code{data.frame} object or an \verb{sf data.frame} object
}
\description{
Download population and socioeconomic data from the Brazilian Census aggregated
on a hexagonal grid based on the global H3 index at resolution 8, with a size of
357 meters (short diagonal) and an area of 0.74 km2. More information about H3 at
\url{https://h3geo.org/docs/core-library/restable/}.
}
\section{Data dictionary:}{
\tabular{llll}{
   \strong{Data type} \tab \strong{column} \tab \strong{Description} \tab \strong{Value} \cr
   geographic \tab \code{abbrev_muni} \tab Abbreviation of city name (3 letters) \tab  \cr
   geographic \tab \code{name_muni} \tab City name \tab  \cr
   geographic \tab \code{code_muni} \tab 7-digit code of each city \tab  \cr
   geographic \tab \code{id_hex} \tab Unique id of hexagonal cell \tab  \cr
   sociodemographic \tab \code{P001} \tab Total number of residents \tab  \cr
   sociodemographic \tab \code{P002} \tab Number of white residents \tab  \cr
   sociodemographic \tab \code{P003} \tab Number of black residents \tab  \cr
   sociodemographic \tab \code{P004} \tab Number of indiginous residents \tab  \cr
   sociodemographic \tab \code{P005} \tab Number of asian-descendents residents \tab  \cr
   sociodemographic \tab \code{R001} \tab Average household income per capita \tab R$ (Brazilian Reais), values in 2010 \cr
   sociodemographic \tab \code{R002} \tab Income quintile group \tab 1 (poorest), 2, 3, 4, 5 (richest) \cr
   sociodemographic \tab \code{R003} \tab Income decile group \tab 1 (poorest), 2, 3, 4, 5, 6, 7, 8, 9, 10 (richest) \cr
}
}

\examples{
\donttest{
# a single city
bho <- read_population(city = 'Belo Horizonte', year = 2010)
bho <- read_population(city = 'bho', year = 2010)

# all cities
all <- read_population(city = 'all', year = 2010)
}
}
\concept{population data functions}
