% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf_summary.R
\name{orsf_summarize_uni}
\alias{orsf_summarize_uni}
\title{ORSF summary; univariate}
\usage{
orsf_summarize_uni(
  object,
  n_variables = NULL,
  pred_horizon = NULL,
  pred_type = "risk",
  importance = "negate",
  ...
)
}
\arguments{
\item{object}{(\emph{orsf_fit}) a trained oblique random survival forest
(see \link{orsf}).}

\item{n_variables}{(\emph{integer}) how many variables should be summarized?
Setting this input to a lower number will reduce computation time.}

\item{pred_horizon}{(\emph{double}) a value or vector indicating the time(s)
that predictions will be calibrated to. E.g., if you were predicting
risk of incident heart failure within the next 10 years, then
\code{pred_horizon = 10}. \code{pred_horizon} can be \code{NULL} if \code{pred_type} is
\code{'mort'}, since mortality predictions are aggregated over all
event times}

\item{pred_type}{(\emph{character}) the type of predictions to compute. Valid
options are
\itemize{
\item 'risk' : probability of having an event at or before \code{pred_horizon}.
\item 'surv' : 1 - risk.
\item 'chf': cumulative hazard function
\item 'mort': mortality prediction
}}

\item{importance}{(\emph{character}) Indicate method for variable importance:
\itemize{
\item 'none': no variable importance is computed.
\item 'anova': compute analysis of variance (ANOVA) importance
\item 'negate': compute negation importance
\item 'permute': compute permutation importance
}

For details on these methods, see \link{orsf_vi}.}

\item{...}{Further arguments passed to or from other methods (not currently used).}
}
\value{
an object of class 'orsf_summary', which includes data on
\itemize{
\item importance of individual predictors.
\item expected values of predictions at specific values of predictors.
}
}
\description{
Summarize the univariate information from an ORSF object
}
\details{
If \code{pred_horizon} is left unspecified, the median value of
the time-to-event variable in \code{object}'s training data will be used.
It is recommended to always specify your own prediction horizon,
as the median time may not be an especially meaningful horizon to
compute predicted risk values at.

If \code{object} already has variable importance values, you can
safely bypass the computation of variable importance in this function
by setting importance = 'none'.
}
\examples{

object <- orsf(pbc_orsf, Surv(time, status) ~ . - id, n_tree = 25)

# since anova importance was used to make object, we can
# safely say importance = 'none' and skip computation of
# variable importance while running orsf_summarize_uni

orsf_summarize_uni(object, n_variables = 3, importance = 'none')

# however, if we want to summarize object according to variables
# ranked by negation importance, we can compute negation importance
# within orsf_summarize_uni() as follows:

orsf_summarize_uni(object, n_variables = 3, importance = 'negate')


}
\seealso{
as.data.table.orsf_summary_uni
}
