% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohens_d.R
\name{cohens_d}
\alias{cohens_d}
\alias{cohens_d.default}
\alias{cohens_d.data.frame}
\alias{cohens_d.formula}
\alias{cohens_d.htest}
\title{Cohen's d}
\usage{
cohens_d(...)

\method{cohens_d}{default}(
  x,
  y = NULL,
  paired = FALSE,
  corr = c("none", "hedges_g", "glass_delta"),
  na.rm = FALSE,
  ...
)

\method{cohens_d}{data.frame}(
  data,
  dv,
  iv,
  paired = FALSE,
  corr = c("none", "hedges_g", "glass_delta"),
  na.rm = FALSE,
  ...
)

\method{cohens_d}{formula}(
  formula,
  data,
  paired = FALSE,
  corr = c("none", "hedges_g", "glass_delta"),
  na.rm = FALSE,
  ...
)

\method{cohens_d}{htest}(ttest, corr = c("none", "hedges_g", "glass_delta"), ...)
}
\arguments{
\item{...}{Further arguments passed to methods.}

\item{x}{A (non-empty) numeric vector of data values.}

\item{y}{An optional (non-empty) numeric vector of data values.}

\item{paired}{A logical indicating whether Cohen's d should be calculated for
a paired sample or two independent samples \emph{(default)}. Ignored when
calculating Cohen's for one sample.}

\item{corr}{Character specifying the correction applied to calculation of the
effect size: \code{"none"} \emph{(default)} returns Cohen's d,
\code{"hedges_g"} applies Hedges correction and \code{"glass_delta"}
calculates Glass' \eqn{\Delta} (uses the standard deviation of the second
group).}

\item{na.rm}{Logical. Should missing values be removed?}

\item{data}{A data frame containing either the variables in the formula
\code{formula} or the variables specified by \code{dv} and \code{iv}.}

\item{dv}{Character indicating the name of the column in \code{data} for the
dependent variable}

\item{iv}{Character indicating the name of the column in \code{data} for the
independent variable}

\item{formula}{A formula of the form \code{lhs ~ rhs} where \code{lhs} is a
numeric variable giving the data values (dependent variable) and \code{rhs}
a factor with two levels giving the corresponding groups (independent
variable).}

\item{ttest}{An object of class \code{htest} (a call to either \code{t_test}
(preferred) or \code{t.test}).}
}
\description{
Calculate Cohen's d from raw data or a call to \code{t_test}/\code{t.test}.
}
\details{
To calculate Cohen's d from summary statistics (M, SD, ..) use
\link{cohens_d_}.
}
\examples{
# Calculate from raw data
cohens_d(c(10, 15, 11, 14, 17), c(22, 18, 23, 25, 20))

# Methods when working with data frames
cohens_d(sleep, dv = extra, iv = group, paired = TRUE)
# or
cohens_d(sleep, dv = "extra", iv = "group", paired = TRUE)
# formula interface
cohens_d(extra ~ group, sleep, paired = TRUE)

# Or pass a call to t_test or t.test
cohens_d(t_test(extra ~ group, sleep, paired = TRUE))
}
\references{
Lakens, D. (2013). Calculating and reporting effect sizes to
facilitate cumulative science: a practical primer for t-tests and ANOVAs.
\emph{Frontiers in Psychology}, 4, 863. doi:10.3389/fpsyg.2013.00863
}
