% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{sdf_register.spatial_rdd}
\alias{sdf_register.spatial_rdd}
\title{Import data from a spatial RDD into a Spark Dataframe.}
\usage{
\method{sdf_register}{spatial_rdd}(x, name = NULL)
}
\arguments{
\item{x}{A spatial RDD.}

\item{name}{Name to assign to the resulting Spark temporary view. If
unspecified, then a random name will be assigned.}
}
\value{
A Spark Dataframe containing the imported spatial data.
}
\description{
Import data from a spatial RDD into a Spark Dataframe.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_geojson_to_typed_rdd(
    sc,
    location = input_location,
    type = "polygon"
  )
  sdf <- sdf_register(rdd)
}

}
