% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_combineModels.R
\name{apollo_combineModels}
\alias{apollo_combineModels}
\title{Combines separate model components.}
\usage{
apollo_combineModels(P, apollo_inputs, functionality)
}
\arguments{
\item{P}{List of vectors, matrices or 3-dim arrays. Likelihood of the model components.}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item"estimate": For model estimation, returns likelihood of model.
  \item"prediction": For model predictions, returns probabilities of all alternatives.
  \item"validate": Validates input.
  \item"zero_LL": Return probabilities with all parameters at zero.
  \item"conditionals": For conditionals, returns likelihood of model.
  \item"output": Checks that the model is well defined.
  \item"raw": For debugging, returns probabilities of all alternatives.
}}
}
\value{
Argument \code{P} with an extra element called "model", which is the product of all the other elements.
}
\description{
Combines model components to create probability for overall model.
}
\details{
This function should be called inside apollo_probabilities after all model components have been produced.

It should be called before apollo_avgInterDraws, apollo_avgIntraDraws, apollo_panelProd and apollo_prepareProb, whichever apply.
}
