% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_varList.R
\name{apollo_varList}
\alias{apollo_varList}
\title{Lists variables names and definitions used in V}
\usage{
apollo_varList(
  apollo_probabilities,
  apollo_beta,
  apollo_inputs,
  V,
  cpp = FALSE
)
}
\arguments{
\item{apollo_probabilities}{Likelihood function of the whole model.}

\item{apollo_beta}{Named numeric vector of parameters to be estimated.}

\item{apollo_inputs}{List of arguments and settings generated by \link{apollo_validateInputs}.}

\item{V}{Named list of functions.}

\item{cpp}{Scalar logical. If TRUE, expressions are modified to match C++ syntax (e.g. x^y -> pow(x,y)). FALSE by default.}
}
\value{
A list containing the following elements (all of type character):
        \itemize{
          \item \code{b}: Vector with the names of variables contained in \code{apollo_beta}.
          \item \code{x}: Vector with the names of variables contained in \code{database}.
          \item \code{d}: Vector with the names of variables contained in \code{draws}.
          \item \code{r}: Matrix with the names (first column) and definitions (second column) of variables contained in \code{apollo_randCoeff}.
          \item \code{p}: Matrix with the names (first column) and definitions (second column) of variables contained in \code{apollo_probabilities}.
          \item \code{v}: Matrix with the names (first column) and definitions (second column) of utilities contained in \code{V}.
        }
}
\description{
Returns a list containing the names and definitions of variables used in V
}
\details{
It looks for variables in apollo_beta, apollo_randCoeff, draws, and 
apollo_probabilities. It returns them in a list ordered by origin.
}
