% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_bootstrap.R
\name{apollo_bootstrap}
\alias{apollo_bootstrap}
\title{Bootstrap a model}
\usage{
apollo_bootstrap(
  apollo_beta,
  apollo_fixed,
  apollo_probabilities,
  apollo_inputs,
  estimate_settings = list(estimationRoutine = "bfgs", maxIterations = 200, writeIter =
    FALSE, hessianRoutine = "none", printLevel = 2L, silent = FALSE, maxLik_settings =
    list()),
  bootstrap_settings = list(nRep = 30, samples = NA, calledByEstimate = FALSE, recycle
    = TRUE)
)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not change during estimation.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters.
  \item apollo_inputs: List containing options of the model. See \link{apollo_validateInputs}.
  \item functionality: Character. Can be either "estimate" (default), "prediction", "validate", "conditionals", "zero_LL", or "raw".
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{estimate_settings}{List. Options controlling the estimation process. See \link{apollo_estimate}.
\code{hessianRoutine='none'} by default.}

\item{bootstrap_settings}{List. Options defining the sampling procedure. The following are valid options.
\itemize{
  \item \strong{nRep}: Numeric scalar. Number of times the model must be estimated with different samples. Default is 30.
  \item \strong{samples}: Numeric matrix or data.frame. Optional argument. Must have as many rows as 
                          observations in the \code{database}, and as many columns as number of repetitions
                          wanted. Each column represents a re-sample, and each element the number of times 
                          that observation must be included in the sample. If this argument is provided, 
                          then \code{nRep} is ignored. Note that this allows sampling at the observation 
                          rather than the individual level, which is not recommended for panel data.
  \item \strong{seed}: \strong{DEPRECATED, \code{apollo_control$seed} is used since v0.2.5}. Numeric scalar (integer). 
                       Random number generator seed to generate the bootstrap samples. Only used if \code{samples} 
                       is \code{NA}. Default is 24.
  \item \strong{calledByEstimate}: Logical. TRUE if \code{apollo_bootstrap} is called by \code{apollo_estimate}. FALSE by default.
  \item \strong{recycle}: Logical. If TRUE, the function will look for old output files and append new repetitions to them. If FALSE, output files will be overwritten.
}}
}
\value{
List with three elements.
        \itemize{
          \item \code{estimates}: Matrix containing the parameter estimates for each repetition. As many rows as repetitions and as many columns as parameters.
          \item \code{varcov}: Covariance matrix of the estimated parameters across the repetitions.
          \item \code{LL}: Vector of final loglikelihoods of each repetition.
        }
        This function also writes three output files to the working directory, with the following names ('x' represents the model name):
        \itemize{
          \item \strong{x_bootstrap_params.csv}: Table containing the parameter estimates, loglikelihood, and number of observations for each repetition.
          \item \strong{x_bootstrap_samples.csv}: Table containing the description of the sample used in each repetition. Same format than \code{bootstrap_settings$samples}.
          \item \strong{x_bootstrap_vcov}: Table containing the covariance matrix of estimated parameters across the repetitions.
        }
}
\description{
Samples individuals with replacement from the database, and estimates the model in each sample.
}
\details{
This function implements a basic block bootstrap. It estimates the model parameters on \code{nRep} number of different samples.
Each new sample is constructed by sampling \strong{with replacement} from the original full sample. Each new sample has as many 
individuals as the original sample, though some of them may be repeated. Sampling is done at the \strong{individual} level, 
therefore if different individuals have different number of observations, each re-sample could have different number of observations.

If the sampling wants to be done at the individual level (not recommended on panel data), then the optional 
\code{bootstrap_settings$samples} argument should be provided.

For each sample, only the parameters and loglikelihood are estimated. Standard errors are not calculated (they may be in 
future versions). The composition of each re-sample is stored on a file, though it should be consistent across runs.

This function writes three different files to the working directory:
\itemize{
  \item \code{modelName_bootstrap_params.csv}: Records the estimated parameters, final loglikelihood, and number of observations on each re-sample
  \item \code{modelName_bootstrap_samples.csv}: Records the composition of each re-sample.
  \item \code{modelName_bootstrap_vcov.csv}: Variance-covariance matrix of the estimated parameters across re-samples.
}
The first two files are updated throughout the run of this function, while the last one is only written once the function finishes.

When run, this function will look for the first two files above in the working directory. If they are found, the function will
attempt to pick up re-sampling from where those files left off. This is useful in cases where the original bootstrapping was 
interrupted, or when additional re-sampling wants to be performed.
}
