% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{loglikelihood}
\alias{loglikelihood}
\title{Negative 2 log likelihood}
\usage{
loglikelihood(b, dataset)
}
\arguments{
\item{b}{intercept and coefficients of a generalized linear model.}

\item{dataset}{a test dataset used to derive the likelihood.}
}
\value{
the function returns the -2 * log likelihood.
}
\description{
Calculate the -2 * log likelihood of a dataset given a specified model.
}
\examples{
## Using the mtcars dataset
## Resample, fit an ordinary least squares model and calculate likelihood
data(mtcars)
mtc.data <- cbind(1,datashape(mtcars, y = 8, x = c(1, 6, 9)))
head(mtc.data)
mtc.boot <- randboot(mtc.data, replace = TRUE)
boot.betas <- ml.rgr(mtc.boot)
loglikelihood(b = boot.betas, dataset = mtc.data)
}

