% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-setters.R
\docType{methods}
\name{replaceHorizons<-}
\alias{replaceHorizons<-}
\alias{replaceHorizons<-,SoilProfileCollection-method}
\title{Replace Data in Horizon Slot}
\usage{
\S4method{replaceHorizons}{SoilProfileCollection}(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{value}{An object inheriting \code{data.frame}}
}
\description{
Replaces horizon data with new data.frame object.
}
\examples{

# load test data
data(sp2)

# promote to SPC
depths(sp2) <- id ~ top + bottom

# one profile
p <- sp2[1,]

# 23 variables in horizon data
length(horizonNames(sp2))

# remove all but essential ones
replaceHorizons(p) <- horizons(p)[,c(idname(p),hzidname(p),horizonDepths(p))]

# inspect result (a clean slate)
horizons(p)

}
