% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkHzDepthLogic.R
\name{checkHzDepthLogic}
\alias{checkHzDepthLogic}
\title{Check a SoilProfileCollection object for errors in horizon depths.}
\usage{
checkHzDepthLogic(
  x,
  hzdepths = NULL,
  idname = NULL,
  fast = FALSE,
  byhz = FALSE
)
}
\arguments{
\item{x}{\code{SoilProfileCollection} or \code{data.frame} object to check}

\item{hzdepths}{character vector, describing top and bottom depths in a \code{SoilProfileCollection} or \code{data.frame}. \code{horizonDepths(x)} is used when \code{x} is a \code{SoilProfileCollection}.}

\item{idname}{character, describing the column containing profile IDs in a \code{SoilProfileCollection} or \code{data.frame}. \code{idname(x)} is used when \code{x} is a \code{SoilProfileCollection}.}

\item{fast}{logical, When \code{TRUE}, details about specific test results are not needed, the operation can allocate less memory and run approximately 5x faster.}

\item{byhz}{logical, apply logic tests to profiles (\code{FALSE}) or individual horizons (\code{TRUE})?}
}
\value{
A \code{data.frame} containing profile IDs, validity boolean (\code{valid}) and test results if \code{fast = FALSE}.

The \code{data.frame} will have as many rows as profiles in \code{x} (\code{length(x)}).
\itemize{
\item \code{id} : Profile IDs, named according to \code{idname(x)}
\item \code{valid} : boolean, profile passes all of the following tests
\item \code{depthLogic} : boolean, errors related to depth logic
\item \code{sameDepth} : boolean, errors related to same top/bottom depths
\item \code{missingDepth} : boolean, NA in top / bottom depths
\item \code{overlapOrGap} : boolean, gaps or overlap in adjacent horizons (\code{NA} when \code{byhz = TRUE})
}
}
\description{
This function inspects a \code{SoilProfileCollection} object, looking for four common errors in horizon depths:
\enumerate{
\item bottom depth shallower than top depth
\item equal top and bottom depth
\item missing top or bottom depth (e.g. \code{NA})
\item gap or overlap between adjacent horizons (only if \code{byhz = FALSE})
}
}
\examples{

## sample data

data(sp3)
depths(sp3) <- id ~ top + bottom

# these data should be clean
res <- checkHzDepthLogic(sp3)

head(res)

# less memory if only concerned about net validity
res <- checkHzDepthLogic(sp3, fast = TRUE)

head(res)

}
\author{
D.E. Beaudette, A.G. Brown, S.M. Roecker
}
