% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{hz_intersect}
\alias{hz_intersect}
\title{Intersecting horizon boundaries by horizon depths}
\usage{
hz_intersect(x, y, idcol = "id", depthcols = c("top", "bottom"))
}
\arguments{
\item{x}{a \code{data.frame}}

\item{y}{a \code{data.frame}}

\item{idcol}{character: column name of the pedon ID within the object.}

\item{depthcols}{a character vector of length 2 specifying the names of the horizon depths (e.g. \code{c("top", "bottom")}).}
}
\value{
A \code{data.frame} with harmonized depth intervals (i.e. segment_id) and columns from both of the original \code{data.frame}. If both \code{data.frame} contain the same column names, they will both be returned (with the exception of the idcol and depthcols), and appended with either x or y to indicate which \code{data.frame} they originated from.
}
\description{
This function intersects two horizon tables by harmonizing their depths and merging them where they overlap. This can be useful to rejoin the results of \code{hz_dissolve()} to it's original horizon table, and then perform an aggregation on the dissolved variables.
}
\details{
.
}
\examples{

h <- data.frame(
  id = 1,
  top    = c(0,  25, 44, 46, 50),
  bottom = c(25, 44, 46, 50, 100),
  by     = c("Yes", "Yes", "No", "No", "Yes"),
  clay   = c(10, 12, 27, 35, 16)
)

hz_dissolve(h, "by")

hz_intersect(x = hz_dissolve(h, "by"), y = h)

hi <- hz_intersect(x = h, y = hz_dissolve(h, "by"))
aggregate(clay ~ dissolve_id, data = hi, mean)

}
\seealso{
\code{\link[=hz_dissolve]{hz_dissolve()}}, \code{\link[=hz_lag]{hz_lag()}}, \code{\link[=hz_segment]{hz_segment()}}
}
\author{
Stephen Roecker
}
