% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-near-point.R
\name{near_point}
\alias{near_point}
\title{Search for places near a point by radius}
\usage{
near_point(
  x,
  y,
  radius = 1000,
  search_text = NULL,
  category_id = NULL,
  icon = NULL,
  token = arc_token()
)
}
\arguments{
\item{x}{The x coordinate, or longitude, to search from, in WGS84 decimal degrees.}

\item{y}{The y coordinate, or latitude, to search from, in WGS84 decimal degrees.}

\item{radius}{Default \code{1000}. The radius in meters to search for places. Maximum value of \code{10000}.}

\item{search_text}{Default \code{NULL}. Free search text for places against names, categories etc. Must be a scalar value.}

\item{category_id}{Default \code{NULL}. A character vector which filters places to those that match the category IDs.}

\item{icon}{Default \code{NULL}. Must be one of \code{"svg"}, \code{"png"} \code{"cim"}. Determines whether icons are returned and the type of icon to use with a place or category.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[arcgisutils:auth_code]{auth_code()}}
or related function}
}
\value{
An \code{sf} object with columns
\itemize{
\item \code{place_id}: The unique Id of this place. The ID can be passed to \code{place_details()} to retrieve additional details.
\item \code{name}: The name of the place, or point of interest. You can search for places by name using the searchText property
\item \code{distance}: A double vector of the distance, in meters, from the place to the search point.
\item \code{categories}: A \code{data.frame} with two columns \code{category_id} and \code{label}. Categories are uniquely identified by a categoryId. For example, \code{17119} identifies a "Bicycle Store" and \code{10051} identifies a "Stadium". Note that a single place can belong to multiple categories (for example, a petrol station could also have a super-market).
\item \code{icon}: A character vector of the URL for an icon for this place or category in either svg, cim or png format.
\item \code{geometry}: an \code{sfc_POINT} object in \code{EPSG:4326}
}
}
\description{
Finds places that are within a given radius of a specified location. The returned places contain basic data such as name, category and location.
}
\examples{
\dontrun{
near_point(-117.194769, 34.057289)
near_point(139.75, 35.66)
}
}
\references{
\href{https://developers.arcgis.com/rest/places/near-point-get}{API Documentation}
}
