% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-crs.R
\name{validate_crs}
\alias{validate_crs}
\title{Validate CRS object}
\usage{
validate_crs(crs, arg = rlang::caller_arg(crs), call = rlang::caller_env())
}
\arguments{
\item{crs}{a representation of a coordinate reference system.}

\item{arg}{An argument name in the current function.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
Returns a list of length 1 with an element named \code{spatialReference} which is itself
a named list.

If the provided CRS returns a valid well-known ID (WKID) \code{spatialReference} contains
a named element called \code{wkid} which is the integer value of the WKID. If the WKID
is not known but the CRS returned is a valid well-known text representation the \code{wkid} field
is \code{NA} and another field \code{wkt} contains the valid wkt.
}
\description{
Takes a representation of a CRS and ensures that it is a valid one. The CRS
is validated using \code{sf::st_crs()} if it cannot be validated, a null CRS is returned.
}
\details{
See \code{\link[sf:st_crs]{sf::st_crs()}} for more details on valid representations.
}
\examples{

# using epsg code integer or string representation
validate_crs(3857)
validate_crs("EPSG:4326")

# using a custom proj4 string
proj4string <- "+proj=longlat +datum=WGS84 +no_defs"

crs <- validate_crs(proj4string)

# using wkt2 (from above result)
crs <- validate_crs(crs$spatialReference$wkt)

}
