% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cache}
\alias{cache}
\title{Enable Caching of a Function Results with the use of Archivist}
\usage{
cache(cacheRepo, FUN, ..., notOlderThan = NULL)
}
\arguments{
  \item{cacheRepo}{An object repository used for storing
  cached objects.}

  \item{FUN}{A function to be called.}

  \item{...}{Arguments for function \code{FUN}.}

  \item{notOlderThan}{Restore an artifact from database
  only if it was created after notOlderThan.}
}
\value{
Result of function call with added additional argument -
md5 hash of function call.
}
\description{
\code{cache} function stores all results of function calls
in local \link{Repository}. All results are stored together
with md5 hashes of the function calls. If function has been
called with same arguments as in the past, then results can
be loaded from repository.

One may specify expiration date for live objects. It may be
useful for objects that can be changed externally (like
queries to database).
}
\details{
\code{cache} function stores all results of function calls
in local \link{Repository} specified by the
\code{cacheRepo} argument. The md5 hash of \code{FUN} and
it's arguments is added as an tag to the repository. If
objects are big and calculations are easy, then disk
input-output operations may take more time than
calculations itself.
}
\examples{
# objects preparation
\dontrun{
cacheRepo <- tempdir()
createEmptyRepo( cacheRepo )
fun <- function(n) {replicate(n, summary(lm(Sepal.Length~Species, iris))$r.squared)}
system.time( res <- cache(cacheRepo, fun, 1000) )
system.time( res <- cache(cacheRepo, fun, 1000) )

testFun <- function(x) {cat(x);x}
# will be executed
tmp <- cache(cacheRepo, testFun, "Say hallo!")
# will loaded from repository
tmp <- cache(cacheRepo, testFun, "Say hallo!")
# will be executed, fails with expiration date
tmp <- cache(cacheRepo, testFun, "Say hallo!", notOlderThan = now())
# will be executed, passes with expiration date [within hour]
tmp <- cache(cacheRepo, testFun, "Say hallo!", notOlderThan = now() - hours(1))

deleteRepo( cacheRepo )
rm( cacheRepo )
}
}
\author{
Przemyslaw Biecek, \email{Przemyslaw.Biecek@gmail.com}
}
\seealso{
For more detailed information check the \pkg{archivist}
package
\href{https://github.com/pbiecek/archivist#-the-list-of-use-cases-}{Use
Cases}.

Other archivist: \code{\link{Repository}};
\code{\link{Tags}}; \code{\link{addTagsRepo}};
\code{\link{archivist-package}};
\code{\link{copyGithubRepo}}, \code{\link{copyLocalRepo}};
\code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
\code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
\code{\link{loadFromGithubRepo}},
\code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
\code{\link{multiSearchInGithubRepo}},
\code{\link{multiSearchInLocalRepo}},
\code{\link{searchInGithubRepo}},
\code{\link{searchInLocalRepo}}; \code{\link{rmFromRepo}};
\code{\link{saveToRepo}};
\code{\link{shinySearchInLocalRepo}};
\code{\link{showGithubRepo}}, \code{\link{showLocalRepo}};
\code{\link{summaryGithubRepo}},
\code{\link{summaryLocalRepo}};
\code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

