% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createEmptyRepo.R
\name{createLocalRepo}
\alias{createEmptyRepo}
\alias{createLocalRepo}
\title{Create an Empty Repository}
\usage{
createLocalRepo(repoDir, force = TRUE, default = FALSE)

createEmptyRepo(...)
}
\arguments{
\item{repoDir}{A character that specifies the directory for the Repository which is to be made.}

\item{force}{If \code{force = TRUE} and \code{repoDir} parameter specifies the directory that doesn't exist,
then function call will force to create new \code{repoDir} directory.
Default set to \code{force = TRUE}.}

\item{default}{If \code{default = TRUE} then \code{repoDir} is set as default Local Repository.}

\item{...}{All arguments are being passed to \code{createLocalRepo}.}
}
\description{
\code{createLocalRepo} creates an empty \link{Repository} in the given directory in which archived artifacts will be stored.
}
\details{
At least one Repository must be initialized before using other functions from the \pkg{archivist} package. 
While working in groups, it is highly recommended to create a Repository on a shared Dropbox/GitHub folder.

All artifacts which are desired to be archived are going to be saved in the local Repository, which is an SQLite 
database stored in a file named \code{backpack}. 
After calling \code{saveToRepo} function, each artifact will be archived in a \code{md5hash.rda} file. 
This file will be saved in a folder (under \code{repoDir} directory) named 
\code{gallery}. For every artifact, \code{md5hash} is a unique string of length 32 that is produced by
\link[digest]{digest} function, which uses a cryptographical MD5 hash algorithm.

To learn more about artifacts visit \link[archivist]{archivist-package}.

Created \code{backpack} database is a useful and fundamental tool for remembering artifact's 
\code{name}, \code{class}, \code{archiving date} etc. (the so called \link{Tags})
or for keeping artifact's \code{md5hash}.

Besides the \code{backpack} database, \code{gallery} folder is created in which all 
artifacts will be archived.

After every \code{saveToRepo} call the database is refreshed. As a result, the artifact is available 
immediately in \code{backpack.db} database for other collaborators.
}
\examples{
\dontrun{
exampleRepoDir <- tempfile()
createLocalRepo( repoDir = exampleRepoDir, default =  TRUE )
data(iris)
saveToLocalRepo(iris)
showLocalRepo()
showLocalRepo(method = "tags")
deleteLocalRepo( repoDir = exampleRepoDir, unset = TRUE, deleteRoot = TRUE)
}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

