% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/chronology.R
\docType{methods}
\name{chronology}
\alias{chronology}
\alias{get_dates}
\alias{get_dates-method}
\alias{set_dates<-}
\alias{set_dates-method}
\alias{get_dates,Matrix-method}
\alias{set_dates<-,Matrix-method}
\alias{set_dates,Matrix-method}
\title{Chronological Information}
\usage{
get_dates(object)

set_dates(object) <- value

\S4method{get_dates}{Matrix}(object)

\S4method{set_dates}{Matrix}(object) <- value
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} matrix of count data (typically of
class \linkS4class{Matrix}).}

\item{value}{A possible value for the element(s) of \code{object} (see
below).}
}
\value{
\code{get_dates} returns a two-columns \code{\link{data.frame}}.
}
\description{
\code{set_dates} and \code{get_dates} allow to get or set the dates of an
object.
}
\details{
An attempt is made to interpret the argument \code{value} in a suitable way.
 \emph{Note} that errors are assumed to be given at \code{1} sigma.

 If \code{value} is a:
 \describe{
  \item{\code{character} vector}{it is assumed to contain Roman numerals.}
  \item{\code{numeric} or \code{integer} \code{vector}}{these values are
  assumed to represent dates without known errors.}
  \item{\code{list}}{containing components "\code{value}" and "\code{error}",
  these are used to define dates and corresponding errors.}
  \item{\code{matrix} or \code{data.frame} with two or more columns}{the
  first is assumed to contain the dates and the second the error values.
  \emph{Note} that if \code{value} has columns named "\code{value}" and
  "\code{error}", these columns will be used.}
 }
}
\examples{
## Create a count data matrix
A <- CountMatrix(data = sample(0:10, 100, TRUE), nrow = 10, ncol = 10,
                 dimnames = list(LETTERS[1:10], NULL))

## Set dates as a matrix
B <- matrix(data = sample(0:10, 20, TRUE), nrow = 10, ncol = 2)
set_dates(A) <- B
get_dates(A)

## Set dates as a data.frame
B <- data.frame(sample(0:10, 5, TRUE), sample(0:10, 5, TRUE),
                row.names = LETTERS[seq(1, 10, 2)])
set_dates(A) <- B
get_dates(A)

## Set dates as a list
B <- list(value = sample(0:10, 10, TRUE), error = sample(0:10, 10, TRUE))
set_dates(A) <- B
get_dates(A)

## Set dates as a numeric vector
B <- sample(0:10, 10, TRUE)
suppressWarnings(set_dates(A) <- B)
get_dates(A)

## Set dates as a character vector
B <- c("X", "IX", "VIII", "VII", "VI", "V", "IV", "III", "II", "I")
set_dates(A) <- B
get_dates(A)

## Unset dates
set_dates(A) <- NULL
get_dates(A)
}
\author{
N. Frerebeau
}
\concept{chronology}
