% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/clean.R
\docType{methods}
\name{replace}
\alias{replace}
\alias{replace_NA}
\alias{replace_NA-method}
\alias{replace_Inf}
\alias{replace_Inf-method}
\alias{replace_zero}
\alias{replace_zero-method}
\alias{replace_NA,matrix-method}
\alias{replace_Inf,matrix-method}
\alias{replace_zero,matrix-method}
\title{Data Replacement}
\usage{
replace_NA(x, ...)

replace_Inf(x, ...)

replace_zero(x, ...)

\S4method{replace_NA}{matrix}(x, value = 0)

\S4method{replace_Inf}{matrix}(x, value = 0)

\S4method{replace_zero}{matrix}(x, value)
}
\arguments{
\item{x}{A \code{\link{matrix}}, a \code{\link{data.frame}} or a \verb{*Matrix} object.}

\item{...}{Currently not used.}

\item{value}{A possible value to replace missing or infinite values of \code{x}.}
}
\description{
Replaces \code{\link[=NA]{missing}} or \code{\link[=is.finite]{infinite}} values or zeros.
}
\examples{
## Create a count data matrix
X <- CountMatrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)
k <- sample(1:25, 3, FALSE)

## Add zeros
X[k] <- 0L
## Remove row with zeros
remove_zero(X, margin = 1)
## Remove column with zeros
remove_zero(X, margin = 2)

## Add NA
X[k] <- NA
## Remove row with zeros
remove_NA(X, margin = 1)
## Remove column with zeros
remove_NA(X, margin = 2)
}
\seealso{
Other utilities: 
\code{\link{remove}()}
}
\author{
N. Frerebeau
}
\concept{utilities}
