% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{confidence_mean}
\alias{confidence_mean}
\alias{confidence_mean-method}
\alias{confidence_mean,numeric-method}
\title{Confidence Interval for a Mean}
\usage{
confidence_mean(object, ...)

\S4method{confidence_mean}{numeric}(object, level = 0.95, type = c("student", "normal"))
}
\arguments{
\item{object}{A \code{\link{numeric}} vector.}

\item{...}{Currently not used.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.
Must be a single number between \eqn{0} and \eqn{1}.}

\item{type}{A \code{\link{character}} string giving the type of confidence
interval to be returned. It must be one "\code{student}" (the default) or
"\code{normal}". Any unambiguous substring can be given.}
}
\value{
A length-two \code{\link{numeric}} vector giving the lower and upper confidence
limits.
}
\description{
Computes a confidence interval for a mean at a desired level of significance.
}
\examples{
## Confidence interval for a mean
x <- seq(from = -4, to = 4, by = 0.01)
y <- dnorm(x)

confidence_mean(y, type = "student")
confidence_mean(y, type = "normal")

## Confidence interval for a propotion
confidence_binomial(118, n = 236)

x <- c(35, 74, 22, 69)
confidence_multinomial(x)
}
\seealso{
Other summary statistics: 
\code{\link{confidence_binomial}()},
\code{\link{confidence_multinomial}()}
}
\author{
N. Frerebeau
}
\concept{summary statistics}
