% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\name{permutations}
\alias{permutations}
\title{Permutations generator}
\usage{
permutations(n, k = n, x = NULL, freq = NULL, replace = FALSE,
  type = "r")
}
\arguments{
\item{n}{an integer. If \code{freq} is not NULL, \code{n} would be set as \code{sum(freq)},
otherwise if \code{x} is not NULL, \code{n} would be set as \code{length(x)}.}

\item{k}{an integer}

\item{x}{an optional vector indicating item labels}

\item{freq}{an integer vector of item repeat frequencies}

\item{replace}{an logical to draw items with replacement}

\item{type}{if "r", "c" or "l" is specified, the returned value would be a
"row-major" matrix, a "column-major" matrix or a list respectively}
}
\description{
This function generates all the permutations of selecting \code{k} items from \code{n} items.
The results are in lexicographical order.
}
\examples{
permutations(3)
permutations(x = LETTERS[1:3])

# choose 2 from 4
permutations(4, 2)
permutations(x = LETTERS[1:3], k = 2)

# multiset with frequencies c(2, 3)
permutations(freq = c(2, 3), k = 3)

# with replacement
permutations(4, 2, replace = TRUE)

# column major
permutations(3, type = "c")
permutations(4, 2, type = "c")

# list output
permutations(3, type = "l")
permutations(4, 2, type = "l")

# zero sized permutations
dim(permutations(0))
dim(permutations(5, 0))
dim(permutations(5, 6))
dim(permutations(0, 0))
dim(permutations(0, 1))

}
\seealso{
\link{ipermutations} for iterating permutations and \link{npermutations} to calculate number of permutations
}
