context("Partitions")

test_that("Integer partitions - npartitions", {
    expect_equal(npartitions(10), 42)
    expect_equal(npartitions(100), 190569292)
    expect_error(npartitions(150), "integer overflow")
    expect_equal(npartitions(10, bigz = TRUE), 42)
    expect_equal(npartitions(100, bigz = TRUE), 190569292)
    expect_equal(npartitions(150, bigz = TRUE), gmp::as.bigz("40853235313"))
    expect_equal(npartitions(0), 1)
    expect_error(npartitions(-1), "expect non-negative integer")
    expect_error(npartitions(1.5), "expect non-negative integer")
})

test_that("Integer partitions - ascending partitions", {
    part <- partitions(10)
    expect_equal(nrow(part), 42)
    expect_equal(ncol(part), 10)
    expect_equal(part[1, ], rep(1, 10))
    expect_equal(part[2, ], c(rep(1, 8), 2, 0))
    expect_equal(part[42, ], c(10, rep(0, 9)))
    expect_true(all(apply(part, 1, sum) == 10))

    part <- partitions(10, type = "r")
    expect_equal(nrow(part), 42)
    expect_equal(ncol(part), 10)
    expect_equal(part[1, ], rep(1, 10))
    expect_equal(part[2, ], c(rep(1, 8), 2, 0))
    expect_equal(part[42, ], c(10, rep(0, 9)))
    expect_true(all(apply(part, 1, sum) == 10))

    part <- partitions(10, type = "c")
    expect_equal(nrow(part), 10)
    expect_equal(ncol(part), 42)
    expect_equal(part[, 1], rep(1, 10))
    expect_equal(part[, 2], c(rep(1, 8), 2, 0))
    expect_equal(part[, 42], c(10, rep(0, 9)))
    expect_true(all(apply(part, 2, sum) == 10))

    part <- partitions(10, type = "l")
    expect_equal(length(part), 42)
    expect_equal(part[[1]], rep(1, 10))
    expect_equal(part[[2]], c(rep(1, 8), 2))
    expect_equal(part[[42]], 10)
    expect_true(all(sapply(part, sum) == 10))

    expect_error(partitions(150), "too many results")
    expect_error(partitions(-1), "expect non-negative integer")
    expect_error(partitions(1.5), "expect non-negative integer")
})

test_that("Integer partitions - descending partitions", {
    part <- partitions(10, descending = TRUE)
    expect_equal(nrow(part), 42)
    expect_equal(ncol(part), 10)
    expect_equal(part[1, ], c(10, rep(0, 9)))
    expect_equal(part[41, ], c(2, rep(1, 8), 0))
    expect_equal(part[42, ], rep(1, 10))
    expect_true(all(apply(part, 1, sum) == 10))

    part <- partitions(10, descending = TRUE, type = "r")
    expect_equal(nrow(part), 42)
    expect_equal(ncol(part), 10)
    expect_equal(part[1, ], c(10, rep(0, 9)))
    expect_equal(part[41, ], c(2, rep(1, 8), 0))
    expect_equal(part[42, ], rep(1, 10))
    expect_true(all(apply(part, 1, sum) == 10))

    part <- partitions(10, descending = TRUE, type = "c")
    expect_equal(nrow(part), 10)
    expect_equal(ncol(part), 42)
    expect_equal(part[, 1], c(10, rep(0, 9)))
    expect_equal(part[, 41], c(2, rep(1, 8), 0))
    expect_equal(part[, 42], rep(1, 10))
    expect_true(all(apply(part, 2, sum) == 10))

    part <- partitions(10, descending = TRUE, type = "l")
    expect_equal(length(part), 42)
    expect_equal(part[[1]], 10)
    expect_equal(part[[41]], c(2, rep(1, 8)))
    expect_equal(part[[42]], rep(1, 10))
    expect_true(all(sapply(part, sum) == 10))

    expect_error(partitions(150, descending = TRUE), "too many results")
    expect_error(partitions(-1, descending = TRUE), "expect non-negative integer")
    expect_error(partitions(1.5, descending = TRUE), "expect non-negative integer")
})

test_that("Integer partitions - ascending ipartitions", {
    part <- partitions(10)
    ipart <- ipartitions(10)
    expect_is(ipart, "Partitions")
    expect_equal(ipart$collect(), part)
    expect_equal(ipart$getnext(), part[1, ])
    expect_equal(ipart$getnext(), part[2, ])
    expect_equal(ipart$getnext(2), part[3:4, ])
    ipart$getnext(30)
    expect_equal(nrow(ipart$getnext(30)), 8)
    expect_equal(ipart$getnext(), NULL)

    part <- partitions(10, type = "r")
    ipart$reset()
    expect_is(ipart, "Partitions")
    expect_equal(ipart$collect(), part)
    expect_equal(ipart$getnext(type = "r"), part[1, , drop = FALSE])
    expect_equal(ipart$getnext(type = "r"), part[2, , drop = FALSE])
    expect_equal(ipart$getnext(2, type = "r"), part[3:4, ])
    ipart$getnext(30, type = "r")
    expect_equal(nrow(ipart$getnext(30, type = "r")), 8)
    expect_equal(ipart$getnext(type = "c"), NULL)

    part <- partitions(10, type = "c")
    ipart$reset()
    expect_equal(ipart$collect(type = "c"), part)
    expect_equal(ipart$getnext(type = "c"), part[, 1, drop = FALSE])
    expect_equal(ipart$getnext(type = "c"), part[, 2, drop = FALSE])
    expect_equal(ipart$getnext(2, type = "c"), part[, 3:4])
    ipart$getnext(30, type = "c")
    expect_equal(ncol(ipart$getnext(30, type = "c")), 8)
    expect_equal(ipart$getnext(type = "c"), NULL)

    part <- partitions(10, type = "l")
    ipart$reset()
    expect_equal(ipart$collect(type = "l"), part)
    expect_equal(ipart$getnext(type = "l"), part[1])
    expect_equal(ipart$getnext(type = "l"), part[2])
    expect_equal(ipart$getnext(2, type = "l"), part[3:4])
    ipart$getnext(30, type = "l")
    expect_equal(length(ipart$getnext(30, type = "l")), 8)
    expect_equal(ipart$getnext(type = "l"), NULL)

    expect_error(ipartitions(-1), "expect non-negative integer")
    expect_error(ipartitions(1.5), "expect non-negative integer")
})

test_that("Integer partitions - descending ipartitions", {
    part <- partitions(10, descending = TRUE)
    ipart <- ipartitions(10, descending = TRUE)
    expect_is(ipart, "Partitions")
    expect_equal(ipart$collect(), part)
    expect_equal(ipart$getnext(), part[1, ])
    expect_equal(ipart$getnext(), part[2, ])
    expect_equal(ipart$getnext(2), part[3:4, ])
    ipart$getnext(30)
    expect_equal(nrow(ipart$getnext(30)), 8)
    expect_equal(ipart$getnext(), NULL)

    part <- partitions(10, descending = TRUE, type = "r")
    ipart$reset()
    expect_equal(ipart$collect(type = "r"), part)
    expect_equal(ipart$getnext(type = "r"), part[1, , drop = FALSE])
    expect_equal(ipart$getnext(type = "r"), part[2, , drop = FALSE])
    expect_equal(ipart$getnext(2, type = "r"), part[3:4, ])
    ipart$getnext(30, type = "r")
    expect_equal(nrow(ipart$getnext(30, type = "r")), 8)
    expect_equal(ipart$getnext(type = "r"), NULL)

    part <- partitions(10, descending = TRUE, type = "c")
    ipart$reset()
    expect_equal(ipart$collect(type = "c"), part)
    expect_equal(ipart$getnext(type = "c"), part[, 1, drop = FALSE])
    expect_equal(ipart$getnext(type = "c"), part[, 2, drop = FALSE])
    expect_equal(ipart$getnext(2, type = "c"), part[, 3:4])
    ipart$getnext(30, type = "c")
    expect_equal(ncol(ipart$getnext(30, type = "c")), 8)
    expect_equal(ipart$getnext(type = "c"), NULL)

    part <- partitions(10, descending = TRUE, type = "l")
    ipart$reset()
    expect_equal(ipart$collect(type = "l"), part)
    expect_equal(ipart$getnext(type = "l"), part[1])
    expect_equal(ipart$getnext(type = "l"), part[2])
    expect_equal(ipart$getnext(2, type = "l"), part[3:4])
    ipart$getnext(30, type = "l")
    expect_equal(length(ipart$getnext(30, type = "l")), 8)
    expect_equal(ipart$getnext(type = "l"), NULL)

    expect_error(ipartitions(-1, descending = TRUE), "expect non-negative integer")
    expect_error(ipartitions(1.5, descending = TRUE), "expect non-negative integer")
})
