% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqlist.R
\name{freqlist}
\alias{freqlist}
\alias{freqlist}
\alias{print.freqlist}
\title{freqlist}
\usage{
freqlist(tab, sparse = FALSE, na.options = c("include", "showexclude",
  "remove"), digits = 2, labelTranslations = NULL, groupBy = NULL, ...)

\method{print}{freqlist}(x, ...)
}
\arguments{
\item{tab}{an object of class \code{"table"} or class \code{"xtabs"}}

\item{sparse}{a logical value indicating whether to keep rows with counts of zero. The default is \code{FALSE}.}

\item{na.options}{a character string indicating how to handling missing values: 'include'
(include values with NAs in counts and percentages),
'showexclude' (show NAs but exclude from cumulative counts and all percentages),
'remove' (remove values with NAs); default is 'include'}

\item{digits}{a single number indicating the number of digits for percentages (passed to \code{\link{round}}; default is 2.}

\item{labelTranslations}{an optional character string of labels to use for variable levels when summarizing.}

\item{groupBy}{an optional character string specifying a variable(s) to use for grouping when calculating cumulative
counts and percentages. \code{\link{summary.freqlist}} will also separate by grouping variable for printing.}

\item{...}{additional arguments passed to the \code{\link[knitr]{kable}} function}

\item{x}{an object of class \code{"freqlist"}}
}
\value{
An object of class \code{"freqlist"} (invisibly for \code{print.freqlist})
}
\description{
Approximate the output from SAS's \code{PROC FREQ} procedure when using the \code{/list} option of the \code{TABLE} statement.
}
\examples{
# load mockstudy data
data(mockstudy)
tab.ex <- table(mockstudy[, c("arm", "sex", "mdquality.s")], useNA = "ifany")
noby <- freqlist(tab.ex, na.options = "include")
summary(noby)
withby <- freqlist(tab.ex, groupBy = c("arm","sex"), na.options = "showexclude")
summary(withby)
}
\seealso{
\code{\link[base]{table}}, \code{\link[stats]{xtabs}}, \code{\link[knitr]{kable}}
}
\author{
Tina Gunderson
}
