% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.tolerances.R
\name{comparison.tolerances}
\alias{comparison.tolerances}
\alias{tol.NA}
\alias{tol.num.absolute}
\alias{tol.num.percent}
\alias{tol.num.pct}
\alias{tol.factor.none}
\alias{tol.factor.levels}
\alias{tol.factor.labels}
\alias{tol.char.both}
\alias{tol.char.case}
\alias{tol.char.trim}
\alias{tol.char.none}
\alias{tol.date.absolute}
\alias{tol.logical.none}
\alias{tol.other.none}
\title{Comparison tolerances}
\usage{
tol.NA(x, y, idx)

tol.num.absolute(x, y, tol)

tol.num.percent(x, y, tol)

tol.num.pct(x, y, tol)

tol.factor.none(x, y)

tol.factor.levels(x, y)

tol.factor.labels(x, y)

tol.char.both(x, y)

tol.char.case(x, y)

tol.char.trim(x, y)

tol.char.none(x, y)

tol.date.absolute(x, y, tol)

tol.logical.none(x, y)

tol.other.none(x, y)
}
\arguments{
\item{x, y}{vectors of the appropriate lengths and types.}

\item{idx}{A logical vector of appropriate length.}

\item{tol}{A numeric tolerance}
}
\value{
A logical vector of length equal to that of \code{x} and \code{y}, where \code{TRUE} denotes a
  difference between \code{x} and \code{y}, and \code{FALSE} denotes no difference between \code{x} and \code{y}.
}
\description{
Internal functions defining tolerances for the \code{\link{comparison.control}} function.
  To create your own tolerance definitions, see the vignette.
}
\details{
\code{tol.NA} takes as differences between two vectors any elements which are NA in one but not the other,
  or which are non-NA in both and \code{TRUE} in \code{idx}. It is useful for handling NAs in custom tolerance functions.
}
\seealso{
\code{\link{comparison.control}}, \code{\link{compare.data.frame}}
}
\author{
Ethan Heinzen
}
