% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableby.stats.R
\name{tableby.stats}
\alias{tableby.stats}
\alias{meansd}
\alias{medianrange}
\alias{median}
\alias{range}
\alias{Nevents}
\alias{medSurv}
\alias{q1q3}
\alias{medianq1q3}
\alias{Nmiss}
\alias{N}
\alias{count}
\alias{countpct}
\title{tableby Summary Statistics Functions}
\usage{
meansd(x, na.rm = TRUE, weights = rep(1, length(x)), ...)

medianrange(x, na.rm = TRUE, weights = rep(1, length(x)), ...)

median(x, na.rm = TRUE, weights = rep(1, length(x)), ...)

range(x, na.rm = TRUE, ...)

Nevents(x, ...)

medSurv(x, ...)

q1q3(x, na.rm = TRUE, weights = rep(1, length(x)), ...)

medianq1q3(x, na.rm = TRUE, weights = rep(1, length(x)), ...)

Nmiss(x, levels = NULL, na.rm = TRUE, weights = rep(1, length(x)), ...)

N(x, levels = NULL, na.rm = TRUE, weights = rep(1, length(x)), ...)

count(x, levels = sort(unique(x)), na.rm = TRUE, weights = rep(1,
  length(x)), ...)

countpct(x, levels = sort(unique(x)), na.rm = TRUE, weights = rep(1,
  length(x)), ...)
}
\arguments{
\item{x}{Usually a vector.}

\item{na.rm}{Should NAs be removed?}

\item{weights}{A vector of weights.}

\item{...}{Other arguments.}

\item{levels}{A vector of levels that character \code{x}s should have.}
}
\value{
Usually a vector of the appropriate numbers.
}
\description{
A collection of functions that will report summary statistics. To create a custom function,
  consider using a function with all three arguments and \code{...}. See the \code{\link{tableby}} vignette
  for an example.
}
\details{
Not all these functions are exported, in order to avoid conflicting NAMESPACES.
}
