% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\docType{class}
\name{AScontrol-classes}
\alias{AScontrol-classes}
\alias{AScontrol}
\alias{AScontrol-class}
\alias{control}
\alias{initialize,AScontrol-method}
\alias{show,AScontrol-method}
\alias{APcontrol-class}
\alias{APcontrol}
\alias{ECcontrol-class}
\alias{ECcontrol}
\alias{coerce-AScontrol}
\alias{coerce,NULL,APcontrol-method}
\alias{coerce,list,APcontrol-method}
\alias{coerce,NULL,ECcontrol-method}
\alias{coerce,list,ECcontrol-method}
\title{Classes AScontrol, APcontrol, ECcontrol ---
Specifying the control Argument of Apriori and Eclat}
\description{
The \code{AScontrol} class holds the algorithmic parameters for the used
mining algorithms.  \code{APcontrol} and \code{ECcontrol} directly extend
\code{AScontrol} with additional slots for parameters only suitable for the
algorithms Apriori (\code{APcontrol}) and Eclat (\code{ECcontrol}).
}
\section{Slots}{

\describe{
\item{\code{sort}}{an integer scalar indicating how to
sort items with respect to their frequency: (default: 2)
\itemize{
\item 1: ascending
\item -1: descending
\item 0: do not sort
\item 2: ascending
\item -2: descending with respect to transaction size sum
}}

\item{\code{verbose}}{a logical indicating whether to report progress}

\item{\code{filter}}{a numeric scalar indicating how to
filter unused items from transactions (default: 0.1)
\itemize{
\item \eqn{=0}: do not filter items with respect to. usage in sets
\item \eqn{<0}: fraction of removed items for filtering
\item \eqn{>0}: take execution times ratio into account
}}

\item{\code{tree}}{a logical indicating whether to
organize transactions as a prefix tree (default: \code{TRUE})}

\item{\code{heap}}{a logical indicating whether to
use heapsort instead of quicksort to sort the transactions
(default: \code{TRUE})}

\item{\code{memopt}}{a logical indicating whether to
minimize memory usage instead of maximize speed (default: \code{FALSE})}

\item{\code{load}}{a logical indicating whether to
load transactions into memory (default: \code{TRUE})}

\item{\code{sparse}}{a numeric value for the
threshold for sparse representation (default: 7)}
}}

\section{Available Slots by Subclass}{

\itemize{
\item \code{APcontrol}:
\code{filter}, \code{tree}, \code{heap}, \code{memopt}, \code{load}, \code{sort}, \code{verbose}
\item \code{ECcontrol}:
\code{sparse}, \code{sort}, \code{verbose}
}
}

\section{Objects from the Class}{

A suitable default control object will be
automatically created by the \code{\link[=apriori]{apriori()}} or the
\code{\link[=eclat]{eclat()}} function. By specifying a named list (names equal to
slots) as the \code{control} argument for \code{\link[=apriori]{apriori()}} or
\code{\link[=eclat]{eclat()}}, default values can be replaced with the values
in the list.

Objects can also be created via coercion.
}

\section{Coercion}{

\itemize{
\item as("NULL", "APcontrol")
\item as("list", "APcontrol")
\item as("NULL", "ECcontrol")
\item as("list", "ECcontrol")
}
}

\references{
Christian Borgelt (2004) \emph{Apriori --- Finding Association
Rules/Hyperedges with the Apriori Algorithm}.
\url{https://borgelt.net/apriori.html}
}
\seealso{
Other mining algorithms: 
\code{\link{APappearance-class}},
\code{\link{ASparameter-classes}},
\code{\link{apriori}()},
\code{\link{eclat}()},
\code{\link{fim4r}()},
\code{\link{ruleInduction}()},
\code{\link{weclat}()}
}
\author{
Michael Hahsler and Bettina Gruen
}
\concept{mining algorithms}
\keyword{classes}
