% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{image}
\alias{image}
\alias{image,itemMatrix-method}
\alias{image,transactions-method}
\alias{image,tidLists-method}
\title{Visual Inspection of Binary Incidence Matrices}
\usage{
\S4method{image}{itemMatrix}(x, xlab = "Items (Columns)", ylab = "Elements (Rows)", ...)

\S4method{image}{transactions}(x, xlab = "Items (Columns)", ylab = "Transactions (Rows)", ...)

\S4method{image}{tidLists}(x, xlab = "Transactions (Columns)", ylab = "Items/itemsets (Rows)", ...)
}
\arguments{
\item{x}{the object (\link{itemMatrix}, \link{transactions} or
\link{tidLists}).}

\item{xlab, ylab}{labels for the plot.}

\item{...}{further arguments passed on to \code{image()} in package
\pkg{Matrix} which in turn are passed on to \code{levelplot()} in
\pkg{lattice}.}
}
\description{
Provides \code{image()} methods to generate level plots to visually
inspect binary incidence matrices, i.e., objects based on
\link{itemMatrix} (e.g., \link{transactions}, \link{tidLists}, items in
\link{itemsets} or rhs/lhs in \link{rules}).  These plots can be used to identify problems
in a data set (e.g., recording problems with some transactions containing
all items).
}
\examples{
data("Epub")

## in this data set we can see that not all
## items were available from the beginning.
image(Epub[1:1000])
}
\seealso{
\code{image()} in package \pkg{Matrix}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{itemMatrix and transactions functions}
\keyword{hplot}
