/*
 * Decompiled with CFR 0.152.
 */
public class FOIL_CARgen
extends Classification {
    private short[][] positiveExamples = null;
    private short[][] negativeExamples = null;
    private short[][] positiveExamples2 = null;
    private short[][] negativeExamples2 = null;
    private final int MAX_NUM_ATTS_IN_ANTECEDENT = 3;

    public FOIL_CARgen(String[] stringArray) {
        super(stringArray);
    }

    @Override
    public double startClassification() {
        System.out.println("START FOIL CLASSIFICATION\n-------------------------");
        System.out.println("Max number of attributes per rule = 3");
        this.currentRlist.startRulelist = null;
        this.currentRlist.setDataArray(this.dataArray);
        this.currentRlist.setNumClasses(this.numClasses);
        if (this.classifiers == null) {
            System.out.println("ERROR: no classifiers array! To create a classifiers array use createClassifiersArray(), contained in ClassAprioriTserial class, called from ther application class.");
            System.exit(1);
        }
        this.startFOIL();
        return this.twoDecPlaces(this.testClassification());
    }

    private void startFOIL() {
        int n;
        this.attributes = new double[this.numOneItemSets - this.numClasses + 1][2];
        for (n = 0; n < this.attributes.length; ++n) {
            this.attributes[n][0] = 0.0;
            this.attributes[n][1] = 0.0;
        }
        block1: for (n = 0; n < this.classifiers.length; ++n) {
            this.generatePosAndNegExamples(this.classifiers[n]);
            short[] sArray = new short[]{this.classifiers[n]};
            while (this.positiveExamples != null) {
                this.positiveExamples2 = this.copy2DshortArray(this.positiveExamples);
                this.negativeExamples2 = this.copy2DshortArray(this.negativeExamples);
                this.attributes2 = this.copyDouble2Darray(this.attributes);
                if (this.noValidGains()) continue block1;
                this.foilGeneration(null, sArray);
            }
        }
    }

    private void foilGeneration(short[] sArray, short[] sArray2) {
        double d = this.getSizeOfExamples(this.positiveExamples2);
        double d2 = this.getSizeOfExamples(this.negativeExamples2);
        this.calculateGains(sArray, d, d2);
        int n = this.getBestGain();
        double d3 = this.attributes2[n][1];
        if (d3 <= 0.7) {
            this.foundRule(sArray, sArray2);
            return;
        }
        sArray = this.reallocInsert(sArray, (short)n);
        this.attributes2[n][0] = 1.0;
        this.positiveExamples2 = this.removeExDoNotSatRule(sArray, this.positiveExamples2);
        this.negativeExamples2 = this.removeExDoNotSatRule(sArray, this.negativeExamples2);
        if (sArray.length >= 3 || this.negativeExamples2 == null) {
            this.foundRule(sArray, sArray2);
            return;
        }
        this.foilGeneration(sArray, sArray2);
    }

    private void foundRule(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            return;
        }
        double d = this.currentRlist.getLaplaceAccuracy(sArray, sArray2[0]);
        this.currentRlist.insertRuleintoRulelist(sArray, sArray2, d);
        this.positiveExamples = this.removeExamplesThatDoSatRule(sArray, this.positiveExamples);
    }

    private void calculateGains(short[] sArray, double d, double d2) {
        for (int i = 1; i < this.attributes2.length; ++i) {
            if ((int)this.attributes2[i][0] != 0) continue;
            short[] sArray2 = this.reallocInsert(sArray, (short)i);
            this.attributes2[i][1] = this.calculateGain(sArray2, d, d2);
        }
    }

    private double calculateGain(short[] sArray, double d, double d2) {
        double d3 = this.getCountExDoSatRule(sArray, this.positiveExamples2);
        if ((int)d3 == 0) {
            return 0.0;
        }
        double d4 = this.getCountExDoSatRule(sArray, this.negativeExamples2);
        double d5 = Math.log(d / (d + d2));
        double d6 = Math.log(d3 / (d3 + d4));
        return d3 * (d6 - d5);
    }

    private int getCountExDoNotSatRule(short[] sArray, short[][] sArray2) {
        if (sArray2 == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < sArray2.length; ++i) {
            if (this.isSubset(sArray, sArray2[i])) continue;
            ++n;
        }
        return n;
    }

    private int getCountExDoSatRule(short[] sArray, short[][] sArray2) {
        if (sArray2 == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < sArray2.length; ++i) {
            if (!this.isSubset(sArray, sArray2[i])) continue;
            ++n;
        }
        return n;
    }

    private boolean noValidGains() {
        boolean bl = true;
        short[] sArray = new short[1];
        double d = this.getSizeOfExamples(this.positiveExamples2);
        double d2 = this.getSizeOfExamples(this.negativeExamples2);
        for (int i = 1; i < this.attributes2.length; ++i) {
            if ((int)this.attributes2[i][0] != 0) continue;
            sArray[0] = (short)i;
            double d3 = this.calculateGain(sArray, d, d2);
            if (!(d3 > 0.7)) continue;
            bl = false;
        }
        return bl;
    }

    private void generatePosAndNegExamples(short s) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.dataArray.length; ++n2) {
            n = this.dataArray[n2].length - 1;
            if (this.dataArray[n2][n] == s) {
                ++n3;
                continue;
            }
            ++n4;
        }
        this.positiveExamples = (short[][])(n3 == 0 ? null : (short[][])new short[n3][]);
        this.negativeExamples = (short[][])(n4 == 0 ? null : (short[][])new short[n4][]);
        n3 = 0;
        n4 = 0;
        for (n2 = 0; n2 < this.dataArray.length; ++n2) {
            n = this.dataArray[n2].length - 1;
            if (this.dataArray[n2][n] == s) {
                this.positiveExamples[n3] = this.copyItemSet(this.dataArray[n2]);
                ++n3;
                continue;
            }
            this.negativeExamples[n4] = this.copyItemSet(this.dataArray[n2]);
            ++n4;
        }
    }

    private int getSizeOfExamples(short[][] sArray) {
        if (sArray == null) {
            return 0;
        }
        return sArray.length;
    }

    private short[][] removeExDoNotSatRule(short[] sArray, short[][] sArray2) {
        if (sArray2 == null) {
            return null;
        }
        int n = this.getCountExDoSatRule(sArray, sArray2);
        if (n == 0) {
            return null;
        }
        short[][] sArrayArray = new short[n][];
        int n2 = 0;
        for (int i = 0; i < sArray2.length; ++i) {
            if (!this.isSubset(sArray, sArray2[i])) continue;
            sArrayArray[n2] = new short[sArray2[i].length];
            for (int j = 0; j < sArray2[i].length; ++j) {
                sArrayArray[n2][j] = sArray2[i][j];
            }
            ++n2;
        }
        return sArrayArray;
    }

    private short[][] removeExamplesThatDoSatRule(short[] sArray, short[][] sArray2) {
        if (sArray2 == null) {
            return null;
        }
        int n = this.getCountExDoNotSatRule(sArray, sArray2);
        if (n == 0) {
            return null;
        }
        short[][] sArrayArray = new short[n][];
        int n2 = 0;
        for (int i = 0; i < sArray2.length; ++i) {
            if (this.isSubset(sArray, sArray2[i])) continue;
            sArrayArray[n2] = new short[sArray2[i].length];
            for (int j = 0; j < sArray2[i].length; ++j) {
                sArrayArray[n2][j] = sArray2[i][j];
            }
            ++n2;
        }
        return sArrayArray;
    }

    @Override
    protected void outputSettings() {
        System.out.println("SETTINGS\n--------");
        System.out.println("File name               = " + this.fileName);
        System.out.println("Num. classes            = " + this.numClasses);
        System.out.println("K value                 = 5");
        System.out.println("Min, best gain          = 0.7");
        System.out.println("Max. size of antecedent = 3");
        System.out.println();
    }
}

