% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBA_helpers.R
\name{CBA_helpers}
\alias{CBA_helpers}
\alias{classes}
\alias{response}
\alias{classFrequency}
\alias{majorityClass}
\alias{transactionCoverage}
\alias{uncoveredClassExamples}
\alias{uncoveredMajorityClass}
\title{Helper Functions For Dealing with Classes}
\usage{
classes(formula, x)

response(formula, x)

classFrequency(formula, x, type = "relative")

majorityClass(formula, transactions)

transactionCoverage(transactions, rules)

uncoveredClassExamples(formula, transactions, rules)

uncoveredMajorityClass(formula, transactions, rules)
}
\arguments{
\item{formula}{A symbolic description of the model to be fitted.}

\item{x, transactions}{An object of class \link[arules:transactions-class]{arules::transactions}
or \link{rules}.}

\item{type}{\verb{"relative" or }"absolute"` to return proportions or
absolute counts.}

\item{rules}{A set of \link{rules}.}
}
\value{
\code{response} returns the response label as a factor.

\code{classFrequency} returns the item frequency for each class label as a
vector.

\code{majorityClass} returns the most frequent class label in the
transactions.
}
\description{
Helper functions to extract the response from transactions or rules, determine the
class frequency, majority class, transaction coverage and the
uncovered examples per class.
}
\examples{
data("iris")

iris.disc <- discretizeDF.supervised(Species ~ ., iris)
iris.trans <- as(iris.disc, "transactions")
inspect(head(iris.trans, n = 3))

# convert the class items back to a class label
response(Species ~ ., head(iris.trans, n = 3))

# Class labels
classes(Species ~ ., iris.trans)

# Class distribution. The iris dataset is perfectly balanced.
classFrequency(Species ~ ., iris.trans)

# Majority class
# (Note: since all class frequencies for iris are the same, the first one is returned)
majorityClass(Species ~ ., iris.trans)

# Use for CARs
cars <- mineCARs(Species ~ ., iris.trans, parameter = list(support = 0.3))

#' # Class labels
classes(Species ~ ., cars)

# Number of rules for each class
classFrequency(Species ~ ., cars, type = "absolute")

# conclusion (item in the RHS) of the rule as a class label
response(Species ~ ., cars)

# How many rules (using the first three rules) cover each transactions?
transactionCoverage(iris.trans, cars[1:3])

# Number of transactions per class not covered by the first three rules
uncoveredClassExamples(Species ~ ., iris.trans, cars[1:3])

# Majority class of the uncovered examples
uncoveredMajorityClass(Species ~ ., iris.trans, cars[1:3])
}
\seealso{
\code{\link[=itemFrequency]{itemFrequency()}}, \link{rules}, \link[arules:transactions-class]{arules::transactions}.
}
\author{
Michael Hahsler
}
