% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{aspline}
\alias{aspline}
\alias{aridge_solver}
\title{Fit B-splines with automatic knot selection.}
\usage{
aspline(
  x,
  y,
  knots = seq(min(x), max(x), length = 42)[-c(1, 42)],
  pen = 10^seq(-3, 3, length = 100),
  degree = 3L,
  family = c("gaussian", "binomial", "poisson"),
  maxiter = 1000,
  epsilon = 1e-05,
  verbose = FALSE,
  tol = 1e-06
)

aridge_solver(
  x,
  y,
  knots = seq(min(x), max(x), length = 42)[-c(1, 42)],
  pen = 10^seq(-3, 3, length = 100),
  degree = 3L,
  family = c("gaussian", "binomial", "poisson"),
  maxiter = 1000,
  epsilon = 1e-05,
  verbose = FALSE,
  tol = 1e-06
)
}
\arguments{
\item{x, y}{Input data, numeric vectors of same length}

\item{knots}{Knots}

\item{pen}{A vector of positive penalty values. The adaptive spline regression is performed for every value of pen}

\item{degree}{The degree of the splines. Recommended value is 3, which corresponds to natural splines.}

\item{family}{A description of the error distribution and link function to be used in the model. The "gaussian", "binomial", and "poisson" families are currently implemented, corresponding to the linear regression, logistic regression, and Poisson regression, respectively.}

\item{maxiter}{Maximum number of iterations  in the main loop.}

\item{epsilon}{Value of the constant in the adaptive ridge procedure (see \emph{Frommlet, F., Nuel, G. (2016)
An Adaptive Ridge Procedure for L0 Regularization}.)}

\item{verbose}{Whether to print details at each step of the iterative procedure.}

\item{tol}{The tolerance chosen to diagnostic convergence of the adaptive ridge procedure.}
}
\value{
A list with the following elements:
\itemize{
\item{\code{sel}: list giving for each value of \code{lambda} the vector of the knot selection weights (a knot is selected if its weight is equal to 1.)}
\item{\code{knots_sel}: list giving for each value of \code{lambda} the vector of selected knots.}
\item{\code{model}: list giving for each value of \code{lambda} the fitted regression model.}
\item{\code{par}: parameters of the models for each value of \code{lambda}.}
\item{\code{sel_mat}: matrix of booleans whose columns indicate whether each knot is selected.}
\item{\code{aic}, \code{bic}, and \code{ebic}: Akaike Information Criterion (AIC), Bayesian Information Criterion (BIC), and Extended BIC (EBIC) scores, for each value of \code{lambda}.}
\item{\code{dim}: number of selected knots for each value of \code{lambda}.}
\item{\code{loglik}: log-likelihood of the selected model, for each value of \code{lambda}.}
}
}
\description{
Fit B-splines with automatic knot selection.
}
\section{Functions}{
\itemize{
\item \code{aridge_solver}: Alias for \code{aspline}, for backwards compatibility.
}}

