% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_set.R
\name{assert_set_equal}
\alias{assert_set_equal}
\title{Check if two sets are identical}
\usage{
assert_set_equal(x, y, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{A vector to compare}

\item{y}{Another vector to compare with \code{x}}

\item{msg}{The error message thrown if the assertion fails (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
Returns \code{invisible(TRUE)} if \code{x} and \code{y} contain all the same elements (ignoring order and duplicates), otherwise throws an error.
}
\description{
This function checks that \code{x} and \code{y} contain exactly the same elements, ignoring order and duplicates.
}
\examples{
# Passes because elements are the same, order doesn't matter
assert_set_equal(c(1, 2, 3), c(3, 2, 1))

# Passes because elements are identical
assert_set_equal(c("A", "B", "C"), c("C", "A", "B"))

try({
  # Throws error because elements are not identical
  assert_set_equal(c(1, 2, 3), c(1, 2))

  # Throws error because elements differ
  assert_set_equal(c("A", "B"), c("A", "B", "C"))
})
}
