% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_rows}
\alias{assert_rows}
\alias{assert_rows_}
\title{Raises error if predicate is FALSE for any row after applying
row reduction function}
\usage{
assert_rows(data, row_reduction_fn, predicate, ..., error_fun = assertr_stop)

assert_rows_(data, row_reduction_fn, predicate, ..., .dots,
  error_fun = assertr_stop, .nameofpred = "")
}
\arguments{
\item{data}{A data frame}

\item{row_reduction_fn}{A function that returns a value for each row of
the provided data frame}

\item{predicate}{A function that returns FALSE when violated}

\item{...}{Comma separated list of unquoted expressions.
Uses dplyr's \code{select} to select
columns from data.}

\item{error_fun}{Function to call if assertion fails. Takes one error
string. Uses \code{stop} by default}

\item{.dots}{Use assert_rows_() to select columns using standard evaluation.}

\item{.nameofpred}{Text representation of predicate for printing in case
        of assertion violation. Will automatically be retrieved if left
        blank (default)}
}
\value{
data if predicate assertions are TRUE. error if not.
}
\description{
Meant for use in a data analysis pipeline, this function applies a
function to a data frame that reduces each row to a single value. Then,
a predicate function is applied to each of the row reduction values. If
any of these predicate applications yield FALSE, this function will raise
an error, effectively terminating the pipeline early. If there are no
FALSEs, this function will just return the data that it was supplied for
further use in later parts of the pipeline.
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{
# returns mtcars
assert_rows(mtcars, num_row_NAs, within_bounds(0,2), mpg:carb)

# equivalent using standard evaluation
assert_rows_(mtcars, num_row_NAs, within_bounds(0,2), "mpg:carb")


library(magrittr)                    # for piping operator

mtcars \%>\%
  assert_rows(rowSums, within_bounds(0,2), vs:am)
  # anything here will run

\dontrun{
mtcars \%>\%
  assert_rows(rowSums, within_bounds(0,1), vs:am)
  # the assertion is untrue so
  # nothing here will run}
}
\seealso{
\code{\link{insist_rows}} \code{\link{assert}}
         \code{\link{verify}} \code{\link{insist}}
}

