% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change-avail.R
\name{change_avail}
\alias{change_avail}
\title{Change the availability matrix to simpliyfy automated ATLANTIS calibrations.}
\usage{
change_avail(dietmatrix, pred = NULL, pred_stanza = NULL, prey = NULL,
  roc, relative = TRUE, consecutive = FALSE)
}
\arguments{
\item{dietmatrix}{Dataframe in 'long' format containing information about availabilities
with columns 'pred', 'prey', 'pred_stanza', 'prey_stanza', 'code', 'prey_id' and
'avail'. The dataframe should be generated with \code{load_dietmatrix()}.}

\item{pred}{Character vector of predator Acronyms (see \code{get_acronyms()}).
Selecting \code{NULL} as pred results in all predators being selected. This
can be helpful if you want to increase the feeding pressure on a specific
prey item by all groups. Default is \code{NULL}.}

\item{pred_stanza}{Integer vector indicating if the predator is juvenile (= 1) or
adult (= 2). \code{pred} and \code{pred_stanza} need to be of the same length.
In rare instances, e.g. pred_stanza being \code{NULL} or one single integer
either all pred_stanzas are selected or the single pred_stanza is applied to all
predators. Default is \code{NULL}.}

\item{prey}{List of character vectors of prey Acronyms (see \code{get_acronyms()}).
\code{pred} and \code{prey} need to be of the same length. Selecting \code{NULL} as
prey results in all prey groups being selected. This
can be helpful if you want to increase the available prey for a specific predator
overall. Default is \code{NULL}.}

\item{roc}{Vector of multiplication factors which shall be applied to the old set of parameters.
Please supply one value per selected group. In case relative is FALSE the new absolute values
can be passed as roc.}

\item{relative}{Logical if TRUE values are changed relative to base values. If FALSE new values can
be passed directly. Default is \code{NULL}.}

\item{consecutive}{Boolean indicating if multiple calls to change_avail are performed one after
another \code{TRUE}. Default is \code{FALSE}.}
}
\value{
parameterfile *.prm file with the new parameter values.
}
\description{
Change the availability of predator XXX on specific preygroups.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
dm <- load_dietmatrix(prm_biol = file.path(d, "VMPA_setas_biol_fishing_Trunk.prm"),
                      fgs = file.path(d, "SETasGroupsDem_NoCep.csv"))

dm1 <- change_avail(dietmatrix = dm,
                    pred = "FPS",
                    pred_stanza = 1,
                    prey = "CEP",
                    roc = 0.1234,
                    relative = FALSE)
# Show only rows with availability of 0.1234
dm1[apply(apply(dm1[, 5:ncol(dm1)], MARGIN = 2, function(x) x == 0.1234), MARGIN = 1, any), ]

dm2 <- change_avail(dietmatrix = dm,
                    pred = c("FPS", "FVS"),
                    pred_stanza = c(1, 2),
                    prey = list(c("FPS", "FVS"), c("FPS", "FVS")),
                    roc = list(c(0.1111, 0.2222), c(0.3333, 0.4444)),
                    relative = FALSE)

# Show only rows with availability of 0.1111, 0.2222, 0.3333 or 0.4444
dm2[apply(apply(dm2[, 5:ncol(dm2)], MARGIN = 2,
function(x) is.element(x,  c(0.1111, 0.2222, 0.3333, 0.4444))), MARGIN = 1, any), ]
}
