% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-box.R
\name{load_box}
\alias{load_box}
\title{Load the box specification file for an Atlantis scenario}
\usage{
load_box(bgm)
}
\arguments{
\item{bgm}{Character string giving the connection to the atlantis bgm file.
The filename ends in \code{.bgm}.}
}
\value{
A list of information regarding boxes for an Atlantis scenario.
}
\description{
Read in the \code{.bgm} file that specifies the the box coordinates
for an Atlantis scenario.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
bgm <- file.path(d, "VMPA_setas.bgm")

boxes <- load_box(bgm)
}
\seealso{
Other load functions: \code{\link{load_bps}},
  \code{\link{load_dietcheck}}, \code{\link{load_fgs}},
  \code{\link{load_init_age}}, \code{\link{load_init}},
  \code{\link{load_nc_physics}}, \code{\link{load_nc}},
  \code{\link{load_rec}}, \code{\link{load_spec_mort}},
  \code{\link{load_txt}}
}
\author{
Kelli Faye Johnson
}
