% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SwordHalClient.R
\docType{class}
\name{SwordHalClient}
\alias{SwordHalClient}
\title{SwordHalClient class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an Sword client
}
\description{
This class models an Sword service client for HAL (Archives Houvertes)
}
\details{
SwordHalClient
}
\note{
Experimental
}
\section{Methods}{

\describe{
 \item{\code{new(url, version, user, pwd, keyring_backend)}}{
   This method is to instantiate an Sword HAL (Archive Ouvertes - \url{https://hal.archives-ouvertes.fr/}) Client.
   By default the version is set to "2".

   The \code{keyring_backend} can be set to use a different backend for storing
   the SWORD API user token with \pkg{keyring} (Default value is 'env').

   The \code{logger} allows to specify the level of log (default is NULL), either "INFO"
   for \pkg{atom4R} logs or "DEBUG" for verbose HTTP client (curl) logs.
 }
 \item{\code{getServiceDocument()}}{
   Gets a representation in R of the SWORD service document (capabilities)
 }
 \item{\code{getCollectionMembers(collectionId)}}{
   Get collection members.
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{API}
\keyword{Client}
\keyword{SWORD}
