% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.auditor_model_performance}
\alias{print.auditor_model_performance}
\title{Prints Model Performance Summary}
\usage{
\method{print}{auditor_model_performance}(x, ...)
}
\arguments{
\item{x}{an object 'auditor_model_performance' created with \code{\link{model_performance}} function.}

\item{...}{other parameters}
}
\description{
Prints Model Performance Summary
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

# use DALEX package to wrap up a model into explainer
exp_glm <- DALEX::explain(model_glm, data = titanic, y = titanic$survived)

# validate a model with auditor
library(auditor)
model_performance(exp_glm)


}
