% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_F1.R
\name{score_f1}
\alias{score_f1}
\title{F1 Score}
\usage{
score_f1(object)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}
}
\value{
An object of class 'auditor_score'.
}
\description{
F1 Score
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

#create an explainer
exp_glm <- DALEX::explain(model_glm, y = titanic$survived)

# calculate score
score_f1(exp_glm)


}
