% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cv_folding}
\alias{cv_folding}
\title{Generates folds for cross-validation}
\usage{
cv_folding(data, L2.unit, k.folds, cv.sampling = c("individuals", "L2 units"))
}
\arguments{
\item{data}{The survey data; must be a tibble.}

\item{L2.unit}{The column name of the factor variable identifying the
context-level unit}

\item{k.folds}{An integer value indicating the number of folds to be
generated.}

\item{cv.sampling}{Cross-validation sampling method. A character-valued
scalar indicating whether cross-validation folds should be created by
sampling individual respondents (\code{individuals}) or geographic units
(\code{L2 units}). Default is \code{L2 units}. \emph{Note:} ignored if
\code{folds} is provided, but must be specified otherwise.}
}
\value{
Returns a list with length specified by \code{k.folds} argument. Each
  element is a tibble with a fold used in k-fold cross-validation.
}
\description{
\code{cv_folding} creates folds used in classifier training within the survey
data.
}
