% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{f1_score}
\alias{f1_score}
\title{Estimates the inverse f1 score, i.e. 0 is the best score and 1 the worst.}
\usage{
f1_score(pred, data.valid, y, L2.unit)
}
\arguments{
\item{pred}{Predictions of outcome. A numeric vector of outcome predictions.}

\item{data.valid}{Test data set. A tibble of data that was not used for
prediction.}

\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable.}

\item{L2.unit}{Geographic unit. A character scalar containing the column name
of the geographic unit in \code{survey} and \code{census} at which outcomes
should be aggregated.}
}
\value{
Returns a tibble containing two f1 prediction errors. The first is
  measured at the level of individuals and the second is measured at the
  context level. The tibble dimensions are 2x3 with variables: measure, value
  and level.
}
\description{
\code{f1_score()} estimates the inverse f1 scores on the individual and state
levels.
}
