% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcmprsk.R
\name{ggcmprsk}
\alias{ggcmprsk}
\title{Draw Cumulative Incidence Curves for Competing Risks}
\usage{
ggcmprsk(x, data, id = NULL, se = FALSE, strata = NULL, facet = NULL, ...)
}
\arguments{
\item{x}{A formula as time+status~1}

\item{data}{A data.frame}

\item{id}{character vector label for status}

\item{se}{logical whether or not show confidence interval}

\item{strata}{character vector label for strata}

\item{facet}{numeric if facet is not NULL, draw plot with selected facets}

\item{...}{Further arguments to be passed to tidycmprsk::cuminc}
}
\value{
An object of class "ggplot"
}
\description{
Draw Cumulative Incidence Curves for Competing Risks
}
\examples{
data(melanoma,package="boot")
melanoma$status1 = ifelse(melanoma$status==1,1,ifelse(melanoma$status==2,0,2))
melanoma$years=melanoma$time/365
\donttest{
ggcmprsk(years+status1~1,data=melanoma)
ggcmprsk(years+status1~1,data=melanoma,id=c("alive","melanoma","other"),se=TRUE)
ggcmprsk(years+status1~sex,data=melanoma)
ggcmprsk(years+status1~sex,data=melanoma,facet=1)
ggcmprsk(years+status1~sex,data=melanoma,
id=c("alive","melanoma","other"),strata=c("female","male"))
ggcmprsk(years+status1~sex,data=melanoma,
id=c("alive","melanoma","other"),strata=c("female","male"),facet=1)
}
}
