% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_interp.R
\name{plot_interp}
\alias{plot_interp}
\alias{plot.selectionTable}
\alias{plot.influenceTable}
\title{Plotting effects interpretation}
\usage{
\method{plot}{selectionTable}(x, quad = TRUE, separation = 0, ...)

\method{plot}{influenceTable}(x, separation = 0, ...)
}
\arguments{
\item{x}{An object of class "selectionTable" or "influenceTable",
created using \code{RSiena::selectionTable()} or \code{RSiena::influenceTable()},
respectively.}

\item{quad}{When TRUE (the default), a quadratic function
(average and total alter) is plotted.
Use \code{quad = FALSE} for similarity effects.}

\item{separation}{This can be used to make the curves visually distinguishable
if they overlap too much without it.
An advisable value then is, e.g., 0.01.}

\item{...}{Other arguments to be passed.}
}
\value{
A plot showing how the selection/influence evaluation function
changes based on ego's value and alter's value of some covariate.
}
\description{
These functions support the interpretation of network and behavior effects
found in stochastic actor-oriented models.
They are S3 plotting methods for objects of class "selectionTable"
or "influenceTable", created using \code{RSiena::selectionTable()}
or \code{RSiena::influenceTable()}, respectively.
They plot how the evaluation function for selection or influence
changes based on ego's value and alter's value of some covariate.
This helps to interpret the effect of that covariate on the network dynamics
or behavior dynamics, respectively.
}
\details{
These functions were originally written by Tom Snijders, and adapted
for use in the \code{{autograph}} package.
}
\examples{
plot(siena_selection)
plot(siena_influence)
}
\references{
For plotting selection tables,
please consult the RSiena manual, Sections 13.1 and 13.3.

For plotting selection tables,
please consult the RSiena manual, Sections 13.2 and 13.4.
}
\seealso{
Other RSiena: 
\code{\link{plot_gof}}

Other RSiena: 
\code{\link{plot_gof}}
}
\author{
Tom Snijders

Thanks to Steffen Triebel and Rene Veenstra for corrections.
}
\concept{RSiena}
