% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autopoints.R
\name{autopoints}
\alias{autopoints}
\title{Automatic facetting of multiple projected scatterplots}
\usage{
autopoints(
  x,
  y,
  z,
  legend = "horizontal",
  proj = "none",
  parameters,
  orientation,
  common.legend = TRUE,
  map = "none",
  size,
  lratio,
  outer.title,
  ...
)
}
\arguments{
\item{x}{Numeric vectors of coordinates at which the
values in \code{z} are measured.}

\item{y}{Numeric vectors of coordinates at which the
values in \code{z} are measured.}

\item{z}{A numeric vector containing the values to be
plotted.}

\item{legend}{A character string indicating where the
color scale should be placed.  The default is
\code{"horizontal"}.  The other valid options are
\code{"none"} and \code{"vertical"}.}

\item{proj}{A character string indicating what projection
should be used for the included \code{x} and \code{y}
coordinates.  The default is \code{"none"}.  The other
valid choices correspond to the \code{"projection"}
argument in the \code{\link[mapproj]{mapproject}}
function, which is used for the projection.}

\item{parameters}{A numeric vector specifying the values
of the \code{parameters} argument in the
\code{\link[mapproj]{mapproject}}.  This may be
necessary when \code{proj != "none"}.}

\item{orientation}{A vector
\code{c(latitude,longitude,rotation)} which describes
where the "North Pole" should be when computing the
projection.  See \code{\link[mapproj]{mapproject}} for
more details.}

\item{common.legend}{A logical value indicating whether a common 
legend scale should be used for all images provided in the
\code{z} array.  Default is \code{TRUE}.  If \code{FALSE}, a
separate legend is used for each image.}

\item{map}{The name of the map to draw on the image.
Default is \code{"none"}.  Other options include
\code{"world"}, \code{"usa"}, \code{"state"},
\code{"county"}, \code{"france"}, \code{"nz"} (New
Zealand), \code{"italy"}, \code{"lakes"}, and
\code{"world2"}, all from the \code{maps} package.}

\item{size}{A vector of length two indicating the number of rows 
and columns that should be used for the series of image data in 
\code{z}.  Note that \code{prod(size)} must match the length of 
the third dimension of \code{z} (if it is an array), or 
\code{c(1, 1)} if \code{z} is a matrix.}

\item{lratio}{A numeric value indicating the ratio of the
smaller dimension of the legend scale to the width of
the image.  Default is \code{lratio = 0.2}.}

\item{outer.title}{A title related to all of the images that is plotted in the outer margin of the figure.}

\item{...}{Additional arguments passed to the 
\code{\link[graphics]{plot}}. e.g., \code{xlab}, \code{ylab}, 
\code{xlim}, \code{ylim}, \code{zlim}, etc.}
}
\description{
\code{autospoints} plots a sequence of scatterplots (with possibly 
projected coordinates) while also automatically plotting a 
color scale matching the image colors to the values of \code{z}.  
Many options are available for customization. See the Examples 
below or execute \code{vignette("autopoints")} to better
understand the possibilities.
}
\details{
The \code{\link[mapproj]{mapproject}} function is used to project 
the \code{x} and \code{y} coordinates when \code{proj != "none"}.

If multiple scatterplots are to be plotted (i.e., if 
\code{z} is a matrix with more than 1 column), then the
\code{main} argument can be a vector with length matching 
\code{ncol(z)}, and each successive element of the vector will 
be used to add a title to each successive scatterplot.  
See the Examples.

Additionally, if \code{common.legend = FALSE}, then separate limits 
for the z-axis of each image can be provided as a list.  
Specifically, if \code{ncol(z) == k}, then \code{zlim} should 
be a list of length \code{k}, and each element of the list should 
be a 2-dimensional vector providing the lower and upper limit, 
respectively, of the legend for each image.  Alternatively, if 
\code{zlim} is a list of length \code{k}, then \code{common.legend}
is set to \code{FALSE}. 

The range of \code{zlim} is cut into \eqn{n} partitions, 
where \code{n} is the length of \code{col}.

It is generally desirable to increase \code{lratio} when
more images are plotted simultaneously.

The multiple plots are constructed using the 
\code{\link[autoimage]{autolayout}} function, which 
is incompatible with the \code{mfrow} and \code{mfcol} arguments 
in the \code{\link[graphics]{par}} function and is also 
incompatible with the \code{\link[graphics]{split.screen}} function.

The \code{mtext.args} argument can be passed through \code{...} 
in order to customize the outer title.  This should be a named
list with components matching the arguments of 
\code{\link[graphics]{mtext}}.

Lines can be added to each image by passing the \code{lines} 
argument through \code{...}.  In that case, \code{lines} should be
a list with components \code{x} and \code{y} specifying the
locations to draw the lines.  The appearance of the plotted lines
can be customized by passing a named list called \code{lines.args}
through \code{...}. The components of \code{lines.args} should match
the arguments of \code{\link[graphics]{lines}}.  See Examples.

Points can be added to each image by passing the \code{points} 
argument through \code{...}.  In that case, \code{points} should be
a list with components \code{x} and \code{y} specifying the
locations to draw the points.  The appearance of the plotted points
can be customized by passing a named list called \code{points.args}
through \code{...}. The components of \code{points.args} should match
the components of \code{\link[graphics]{points}}.  See Examples.

Text can be added to each image by passing the \code{text} 
argument through \code{...}.  In that case, \code{text} should be
a list with components \code{x} and \code{y} specifying the
locations to draw the text, and \code{labels}, a component
specifying the actual text to write.  The appearance of the plotted text
can be customized by passing a named list called \code{text.args}
through \code{...}. The components of \code{text.args} should match
the components of \code{\link[graphics]{text}}.  See Examples.
 
The legend scale can be modified by passing \code{legend.axis.args}
through \code{...}.  The argument should be a named list
corresponding to the arguments of the \code{\link[graphics]{axis}}
function.  See Examples.

The axes can be modified by passing \code{axis.args}
through \code{...}.  The argument should be a named list
corresponding to the arguments of the \code{\link[graphics]{axis}}
function.  The exception to this is that arguments \code{xat} 
and \code{yat} can be specified (instead of \code{at}) to specify
the location of the x and y ticks.  If \code{xat} or \code{yat}
are specified, then this overrides the \code{xaxt} and \code{yaxt}
arguments, respectively.  See the \code{\link[autoimage]{paxes}}
function to see how \code{axis.args can be used.}

The legend margin can be customized by passing \code{legend.mar}
to \code{autpoints} through \code{...}.  This should be a numeric
vector indicating the margins of the legend, identical to how 
\code{par("mar")} is specified.

The various options of the labeling, axes, and legend are largely
independent.  e.g., passing \code{col.axis} through \code{...} 
will not affect the axis unless it is passed as part of the 
named list \code{axis.args}.  However, one can set the various
\code{par} options prior to plotting to simultaneously
affect the appearance of multiple aspects of the plot.  See 
Examples for \code{\link[autoimage]{pimage}}.  After plotting, 
\code{reset.par()} can be used to reset 
the graphics device options to their default values.
}
\examples{
data(co, package = "gear")
easting = co$easting
northing = co$northing
# heated scatterplot for Aluminum and Cadmium
autopoints(easting, northing, co[,c("Al", "Ca")],
           common.legend = FALSE, map = "state",
           main = c("Al", "Ca"), lratio = 0.2,
           legend.mar = c(0.3, 0.1, 0.1, 0.1))

# more complicated heat scatterplot for Aluminum and
# Cadmium used more advanced options
autopoints(co$lon, co$lat, co[,c("Al", "Ca")],
          common.legend = FALSE, 
          map = "county", main = c("Aluminum", "Cadmium"),
          proj = "bonne", parameters = 40,
          text = list(x = c(-104.98, -104.80), y = c(39.74, 38.85), 
                      labels = c("Denver", "Colorado Springs")),
          text.args = list(col = "blue"))
}
\seealso{
\code{\link[autoimage]{autoimage}}, \code{\link[autoimage]{heat_ppoints}}
}
