% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_get_history}
\alias{am_get_history}
\title{Get document history}
\usage{
am_get_history(doc)
}
\arguments{
\item{doc}{An Automerge document}
}
\value{
A list of raw vectors (serialized changes), one for each change
in the document's history, in chronological order.
}
\description{
Returns the full change history of the document as a list of change metadata.
This provides a simpler interface than \code{am_get_changes()} for examining
document history without needing to work with serialized changes directly.
}
\details{
\strong{Note}: A future implementation will add detailed change introspection
functions to extract metadata like commit messages, timestamps,
actor IDs, etc.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "x", 1)
am_commit(doc, "Initial")
am_put(doc, AM_ROOT, "x", 2)
am_commit(doc, "Update")

history <- am_get_history(doc)
cat("Document history contains", length(history), "change(s)\n")

am_close(doc)

}
