% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_mark_clear}
\alias{am_mark_clear}
\title{Clear marks from a text range}
\usage{
am_mark_clear(obj, start, end, name, expand = AM_MARK_EXPAND_NONE)
}
\arguments{
\item{obj}{An Automerge object ID (must be a text object)}

\item{start}{Integer start position (0-based inter-character position, inclusive)}

\item{end}{Integer end position (0-based inter-character position, exclusive)}

\item{name}{Character string identifying the mark to clear (e.g., "bold")}

\item{expand}{Character string controlling mark clearing behavior at
boundaries. Options: \code{"none"} (default), \code{"before"}, \code{"after"}, \code{"both"}.
Use the constants \link{AM_MARK_EXPAND_NONE}, \link{AM_MARK_EXPAND_BEFORE},
\link{AM_MARK_EXPAND_AFTER}, or \link{AM_MARK_EXPAND_BOTH}.}
}
\value{
The text object \code{obj} (invisibly)
}
\description{
Removes marks matching the given name from a range of text. This is the
inverse of \code{\link[=am_mark]{am_mark()}}.
}
\section{Indexing Convention}{

Uses the same 0-based inter-character position indexing as \code{\link[=am_mark]{am_mark()}}.
}

\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

# Add a mark
am_mark(text_obj, 0, 11, "bold", TRUE)
length(am_marks(text_obj))  # 1

# Clear the mark
am_mark_clear(text_obj, 0, 11, "bold")
length(am_marks(text_obj))  # 0

am_close(doc)

}
\seealso{
\code{\link[=am_mark]{am_mark()}}, \code{\link[=am_marks]{am_marks()}}
}
