% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateData.R
\name{simulateData}
\alias{simulateData}
\title{Simulate data}
\usage{
simulateData(theta, X, m, n, boundary = -1, centered = FALSE, k = 2,
  burn = 40, draws = 1)
}
\arguments{
\item{theta}{a vector of coefficients for binary response, or a matrix of coefficients for multicategory response}

\item{X}{n by p design matrix}

\item{m}{width of the grid}

\item{n}{height of the grid}

\item{boundary}{(uncentered only) -1 for no boundary conditions, i>=0 to surround grid with class i observations}

\item{centered}{logical, generates data from centered model if TRUE and uncentered if FALSE}

\item{k}{number of response categories}

\item{burn}{number of burn-in iterations for the Gibbs sampler}

\item{draws}{number of simulated samples to return}
}
\value{
an nxk matrix of responses for draws=1, and a length draws list of nxk response matrices for draws>1
}
\description{
Simulates data from the centered or uncentered binomial or multinomial distribution
}
\examples{

#generate outcomes on a grid using example coefficient values and design matrix
set.seed(42)
#for a multinomial response, beta and eta will have more than one column
#for a binary response, beta and eta will only have one column
#here, we the response variable takes 3 possible values, so beta and eta have two columns
beta=cbind(c(0,1.25,-1,2,-0.8),c(-3,0.25,-5,1,-0.4))

#setting the eta coefficients
eta=cbind(c(0.6,0),c(0,0.6))

#these are the final coefficient values we'll use to generate the data
theta=rbind(beta,eta)

#X matrix with 5 predictors and 900 observations for a 10x10 grid
X=cbind(rep(1,900),replicate(4,rnorm(900)))

#generate data for 30x30 grid
z=simulateData(theta,X,30,30,centered=TRUE,k=3,burn=1)
}
\keyword{simulate}

