% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_formats.R
\name{autoslider_format}
\alias{autoslider_format}
\alias{blue_format}
\alias{orange_format}
\alias{red_format}
\alias{purple_format}
\alias{autoslider_dose_format}
\alias{black_format_ae}
\alias{black_format_tb}
\title{Table color and font}
\usage{
autoslider_format(
  ft,
  odd_header = "#0EAED5",
  odd_body = "#EBF5FA",
  even_header = "#0EAED5",
  even_body = "#D0E4F2",
  font_name = "arial",
  body_font_size = 12,
  header_font_size = 14
)

blue_format(ft, ...)

orange_format(ft, ...)

red_format(ft, ...)

purple_format(ft, ...)

autoslider_dose_format(ft, header_vals = names(ft))

black_format_ae(ft, body_font_size = 8, header_font_size = 8, ...)

black_format_tb(ft, body_font_size = 8, header_font_size = 8, ...)
}
\arguments{
\item{ft}{flextable object}

\item{odd_header}{Hex color code, default to deep sky blue}

\item{odd_body}{Hex color code, default to alice blue}

\item{even_header}{Hex color code, default to slate gray}

\item{even_body}{Hex color code, default to slate gray}

\item{font_name}{Font name, default to arial}

\item{body_font_size}{Font size of the table content, default to 12}

\item{header_font_size}{Font size of the table header, default to 14}

\item{...}{arguments passed to program}

\item{header_vals}{Header}
}
\value{
A flextable with applied theme.
}
\description{
Zebra themed color
}
\section{Functions}{
\itemize{
\item \code{autoslider_format()}: User defined color code and font size

\item \code{blue_format()}: Blue color theme

\item \code{orange_format()}: Orange color theme

\item \code{red_format()}: Red color theme

\item \code{purple_format()}: Purple color theme

\item \code{autoslider_dose_format()}: `AutoslideR` dose formats

\item \code{black_format_ae()}: Black color theme for AE listing

\item \code{black_format_tb()}: Black color theme

}}
\author{
Nina Qi and Jasmina Uzunovic
}
