% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_capacity_reservation}
\alias{ec2_create_capacity_reservation}
\title{Create Capacity Reservation}
\usage{
ec2_create_capacity_reservation(
  InstanceType,
  InstancePlatform,
  InstanceCount,
  ClientToken = NULL,
  AvailabilityZone = NULL,
  AvailabilityZoneId = NULL,
  Tenancy = NULL,
  EbsOptimized = NULL,
  EphemeralStorage = NULL,
  EndDate = NULL,
  EndDateType = NULL,
  InstanceMatchCriteria = NULL,
  TagSpecifications = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceType}{String. The instance type for which to reserve capacity.}

\item{InstancePlatform}{String. The type of operating system for which to reserve capacity.}

\item{InstanceCount}{Integer. The number of instances for which to reserve capacity.}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{AvailabilityZone}{String. The Availability Zone in which to create the Capacity Reservation.[optional]}

\item{AvailabilityZoneId}{String. The ID of the Availability Zone in which to create the Capacity Reservation.[optional]}

\item{Tenancy}{String.   Indicates the tenancy of the Capacity Reservation.[optional]}

\item{EbsOptimized}{Logical. Indicates whether the Capacity Reservation supports EBS-optimized instances.[optional]}

\item{EphemeralStorage}{Logical. Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.[optional]}

\item{EndDate}{String.   The date and time at which the Capacity Reservation expires.[optional]}

\item{EndDateType}{String.   Indicates the way in which the Capacity Reservation ends.[optional]}

\item{InstanceMatchCriteria}{String.   Indicates the type of instance launches that the Capacity Reservation accepts.[optional]}

\item{TagSpecifications}{List. The tags to apply to the Capacity Reservation during launch.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Capacity Reservation
}
\section{InstanceType}{

The instance type for which
to reserve capacity. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance types}
in the \emph{Amazon EC2 User Guide}.
}

\section{InstancePlatform}{

The type of
operating system for which to reserve capacity.
}

\section{InstanceCount}{

The
number of instances for which to reserve
capacity.
}

\section{ClientToken}{

Unique, case-sensitive identifier that you
provide to ensure the idempotency of the request. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensure Idempotency}.
}

\section{AvailabilityZone}{

The
Availability Zone in which to create the Capacity
Reservation.
}

\section{AvailabilityZoneId}{

The ID of the Availability Zone in
which to create the Capacity Reservation.
}

\section{Tenancy}{


Indicates the tenancy of the Capacity Reservation. A Capacity
Reservation can have one of the following tenancy settings:
\itemize{
\item \code{default} - The Capacity Reservation is created on hardware that is
shared with other AWS accounts.
\item \code{dedicated} - The Capacity Reservation is created on single-tenant
hardware that is dedicated to a single AWS account.
}
}

\section{EbsOptimized}{

Indicates whether the Capacity Reservation supports
EBS-optimized instances. This optimization provides dedicated throughput
to Amazon EBS and an optimized configuration stack to provide optimal
I/O performance. This optimization isn\'t available with all instance
types. Additional usage charges apply when using an EBS- optimized
instance.
}

\section{EphemeralStorage}{

Indicates whether the Capacity Reservation
supports instances with temporary, block-level
storage.
}

\section{EndDate}{


The date and time at which the Capacity Reservation expires. When a
Capacity Reservation expires, the reserved capacity is released and you
can no longer launch instances into it. The Capacity Reservation\'s
state changes to \code{expired} when it reaches its end date and time.

You must provide an \code{EndDate} value if \code{EndDateType} is \code{limited}. Omit
\code{EndDate} if \code{EndDateType} is \code{unlimited}.

If the \code{EndDateType} is \code{limited}, the Capacity Reservation is cancelled
within an hour from the specified time. For example, if you specify
5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end
between 13:30:55 and 14:30:55 on 5/31/2019.
}

\section{EndDateType}{


Indicates the way in which the Capacity Reservation ends. A Capacity
Reservation can have one of the following end types:
\itemize{
\item \code{unlimited} - The Capacity Reservation remains active until you
explicitly cancel it. Do not provide an \code{EndDate} if the
\code{EndDateType} is \code{unlimited}.
\item \code{limited} - The Capacity Reservation expires automatically at a
specified date and time. You must provide an \code{EndDate} value if the
\code{EndDateType} value is \code{limited}.
}
}

\section{InstanceMatchCriteria}{


Indicates the type of instance launches that the Capacity Reservation
accepts. The options include:
\itemize{
\item \code{open} - The Capacity Reservation automatically matches all
instances that have matching attributes (instance type, platform,
and Availability Zone). Instances that have matching attributes run
in the Capacity Reservation automatically without specifying any
additional parameters.
\item \code{targeted} - The Capacity Reservation only accepts instances that
have matching attributes (instance type, platform, and Availability
Zone), and explicitly target the Capacity Reservation. This ensures
that only permitted instances can use the reserved capacity.
}

Default: \code{open}
}

\section{TagSpecifications}{

The tags to apply to the Capacity Reservation
during launch.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

