% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_network_insights_analyses}
\alias{ec2_describe_network_insights_analyses}
\title{Describe Network Insights Analyses}
\usage{
ec2_describe_network_insights_analyses(
  NetworkInsightsAnalysisId = NULL,
  NetworkInsightsPathId = NULL,
  AnalysisStartTime = NULL,
  AnalysisEndTime = NULL,
  Filter = NULL,
  MaxResults = NULL,
  DryRun = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInsightsAnalysisId}{List. The ID of the network insights analyses. You must specify either analysis IDs or a path ID.[optional]}

\item{NetworkInsightsPathId}{String. The ID of the path. You must specify either a path ID or analysis IDs.[optional]}

\item{AnalysisStartTime}{String. The time when the network insights analyses started.[optional]}

\item{AnalysisEndTime}{String. The time when the network insights analyses ended.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more of your network insights
analyses.
}
\section{NetworkInsightsAnalysisId}{

The ID of the
network insights analyses. You must specify either analysis IDs or a
path ID.
}

\section{NetworkInsightsPathId}{

The ID of the path. You must specify either
a path ID or analysis IDs.
}

\section{AnalysisStartTime}{

The time when the network
insights analyses started.
}

\section{AnalysisEndTime}{

The time when the network
insights analyses ended.
}

\section{Filter}{


The filters. The following are possible values:
\itemize{
\item PathFound - A Boolean value that indicates whether a feasible path
is found.
\item Status - The status of the analysis (running \| succeeded \|
failed).
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you
have the required permissions for the action, without actually making
the request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

